// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/wait_cancel.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_15_SEC		(15L * 1000L)



// variables ******************************************************************

static	const gsc_wait_t	wait_src[]	=
{
	// flags			main								...			timeout_ms
	{ 0,				GSC_WAIT_MAIN_DMA0,					0, 0, 0,	_15_SEC	},
	{ 0,				GSC_WAIT_MAIN_DMA1,					0, 0, 0,	_15_SEC	},
	{ 0,				GSC_WAIT_MAIN_GSC,					0, 0, 0,	_15_SEC	},

	// flags ...		gsc									...			timeout_ms
	{ 0, 0,				AISS8AO4_WAIT_GSC_AUTO_CAL_DONE,	0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_THRESH_H2L,	0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_THRESH_L2H,	0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_OVERFLOW,		0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_BURST_START,	0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_BURST_DONE,	0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AI_CLOCK,			0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_AO_CLOCK,			0, 0,		_15_SEC	},
	{ 0, 0,				AISS8AO4_WAIT_GSC_DIO_0_L2H,		0, 0,		_15_SEC	},

	// flags ...		io												timeout_ms
	{ 0, 0, 0, 0,		AISS8AO4_WAIT_IO_RX_DONE,				 		_15_SEC	},
	{ 0, 0, 0, 0,		AISS8AO4_WAIT_IO_RX_ERROR,				 		_15_SEC	},
	{ 0, 0, 0, 0,		AISS8AO4_WAIT_IO_RX_TIMEOUT,					_15_SEC	},
	{ 0, 0, 0, 0,		AISS8AO4_WAIT_IO_RX_ABORT,						_15_SEC	},

	// terminate list
	{ 1	}
};

static	gsc_wait_t	wait_dst[SIZEOF_ARRAY(wait_src)];
static	int			wait_fd;
static	os_thread_t	wait_thread[SIZEOF_ARRAY(wait_src)];



//*****************************************************************************
static int _service_test(void)
{
	// There are no settings bits to test here.
	return(0);
}



//*****************************************************************************
static int _wait_thread(void* arg)
{
	int	i		= (int) (long) arg;
	int	ret;

	ret	= aiss8ao4_ioctl(wait_fd, AISS8AO4_IOCTL_WAIT_EVENT, &wait_dst[i]);

	if (ret)
		wait_dst[i].flags	= 0xFFFFFFFF;

	return(0);
}



//*****************************************************************************
static int _create_thread_1(int index)
{
	char		buf[64];
	int			errs;
	int			i;
	int			ret;
	gsc_wait_t	wait;

	wait_dst[index]	= wait_src[index];
	sprintf(buf, "wait cancel %d", index);
	errs	= os_thread_create(	&wait_thread[index],
								buf,
								_wait_thread,
								(void*) (long) index);

	// Wait for the thread to become waiting.

	if (errs == 0)
	{
		wait	= wait_dst[index];

		for (i = 0; i < 100; i++)
		{
			ret	= aiss8ao4_ioctl(wait_fd, AISS8AO4_IOCTL_WAIT_STATUS, &wait);

			if (ret)
			{
				printf(	"FAIL <---  (%d. status request %d: error %d)\n",
						__LINE__,
						index,
						ret);
				errs	= 1;
				break;
			}

			if (wait.count == 1)
				break;

			os_sleep_ms(100);
		}

		if ((errs == 0) && (wait.count != 1))
		{
			printf(	"FAIL <---  (%d. count: expect 1, got %ld)\n",
					__LINE__,
					(long) wait.count);
			errs	= 1;
		}
	}

	return(errs);
}



//*****************************************************************************
static int _create_thread_2(int index)
{
	char		buf[64];
	int			errs;
	int			i;
	int			ret;
	gsc_wait_t	wait;

	wait_dst[index]	= wait_src[0];
	sprintf(buf, "wait cancel %d", index);
	errs	= os_thread_create(	&wait_thread[index],
								buf,
								_wait_thread,
								(void*) (long) index);

	// Wait for the thread to become waiting.

	if (errs == 0)
	{
		wait	= wait_dst[index];

		for (i = 0; i < 100; i++)
		{
			ret	= aiss8ao4_ioctl(wait_fd, AISS8AO4_IOCTL_WAIT_STATUS, &wait);

			if (ret)
			{
				printf(	"FAIL <---  (%d. status request %d: error %d)\n",
						__LINE__,
						index,
						ret);
				errs	= 1;
				break;
			}

			if (wait.count == (index + 1))
				break;

			os_sleep_ms(100);
		}

		if ((errs == 0) && (wait.count != index + 1))
		{
			printf(	"FAIL <---  (%d. count: expect %d, got %ld)\n",
					__LINE__,
					index + 1,
					(long) wait.count);
			errs	= 1;
		}
	}

	return(errs);
}



//*****************************************************************************
static int _delete_thread_1(int index)
{
	int			errs	= 0;
	int			ret;
	gsc_wait_t	wait;

	if (wait_dst[index].flags != 0xFFFFFFFF)
	{
		wait	= wait_dst[index];
		ret		= aiss8ao4_ioctl(wait_fd, AISS8AO4_IOCTL_WAIT_CANCEL, &wait);

		if (ret)
		{
			printf(	"FAIL <---  (%d. calcel request %d: error %d)\n",
					__LINE__,
					index,
					ret);
			errs	= 1;
		}

		if ((errs == 0) && (wait.count != 1))
		{
			printf(	"FAIL <---  (%d. count: expect 1, got %ld)\n",
					__LINE__,
					(long) wait.count);
			errs	= 1;
		}

		errs	+= os_thread_destroy(&wait_thread[index]);
	}

	return(errs);
}



//*****************************************************************************
static int _delete_thread_2(int count)
{
	int			errs	= 0;
	int			i;
	int			ret;
	gsc_wait_t	wait;

	wait	= wait_dst[0];
	ret		= aiss8ao4_ioctl(wait_fd, AISS8AO4_IOCTL_WAIT_CANCEL, &wait);

	if (ret)
	{
		printf(	"FAIL <---  (%d. calcel request: error %d)\n",
				__LINE__,
				ret);
		errs++;
	}

	if ((errs == 0) && (wait.count != count))
	{
		printf(	"FAIL <---  (%d. count: expect %d, got %ld)\n",
				__LINE__,
				count,
				(long) wait.count);
		errs++;
	}

	for (i = 0; i < count; i++)
	{
		if (wait_dst[i].flags != 0xFFFFFFFF)
			errs	+= os_thread_destroy(&wait_thread[i]);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int		errs	= 0;
	int		i;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	wait_fd	= fd;
	memset(wait_dst, 0, sizeof(wait_dst));
	memset(wait_thread, 0, sizeof(wait_thread));

	// Create threads awaiting each of the source crtiteria.

	for (i = 0; (errs == 0) && (wait_src[i].flags == 0) ; i++)
		errs	+= _create_thread_1(i);

	// Cancel each wait and delete the thread.

	for (i = 0; wait_src[i].flags == 0 ; i++)
		errs	+= _delete_thread_1(i);

	// Create multiple threads awaiting the same criteria.

	for (i = 0; (errs == 0) && (wait_src[i].flags == 0) ; i++)
		errs	+= _create_thread_2(i);

	// Cancel each wait and delete the thread.
	errs	+= _delete_thread_2(SIZEOF_ARRAY(wait_src) - 1);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	wait_cancel_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_WAIT_CANCEL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int wait_cancel_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_WAIT_CANCEL");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


