// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/rx_io_timeout.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AISS8AO4_IO_TIMEOUT_MAX,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	(AISS8AO4_IO_TIMEOUT_MIN + AISS8AO4_IO_TIMEOUT_MAX) / 2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AISS8AO4_IO_TIMEOUT_MIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AISS8AO4_IO_TIMEOUT_NO_SLEEP,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AISS8AO4_IO_TIMEOUT_DEFAULT,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	#define	TIEMOUT_1	2
	#define	TIEMOUT_2	6

	static const service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	TIEMOUT_1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	TIEMOUT_2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	u32		data[1];
	long	dt1;
	long	dt2;
	int		errs	= 0;
	int		ret;
	time_t	t1;
	time_t	t2;
	time_t	t3;

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_get_list(fd, list_1);
	t1		= time(NULL);

	if (errs == 0)
	{
		ret	= aiss8ao4_read(fd, data, 4);

		if (ret != 0)
		{
			errs++;
			printf(	"FAIL <---  (%d. aiss8ao4_read(): returned %d, expected 0)\n",
					__LINE__,
					ret);
		}
	}

	errs	+= service_ioctl_set_get_list(fd, list_2);
	t2		= time(NULL);

	if (errs == 0)
	{
		ret	= aiss8ao4_read(fd, data, 4);

		if (ret != 0)
		{
			errs++;
			printf(	"FAIL <---  (%d. aiss8ao4_read(): returned %d, expected 0)\n",
					__LINE__,
					ret);
		}
	}

	t3	= time(NULL);
	dt1	= t2 - t1;
	dt2	= t3 - t2;

	if (errs)
	{
	}
	else if ((dt1 < (TIEMOUT_1 - 1)) || (dt1 > (TIEMOUT_1 + 1)))
	{
		errs++;
		printf(	"FAIL <---  (%d. timeout was %ld, expected %ld to %ld)\n",
				__LINE__,
				dt1,
				(long) TIEMOUT_1 - 1,
				(long) TIEMOUT_1 + 1);
	}
	else if ((dt2 < (TIEMOUT_2 - 1)) || (dt2 > (TIEMOUT_2 + 1)))
	{
		errs++;
		printf(	"FAIL <---  (%d. timeout was %ld, expected %ld to %ld)\n",
				__LINE__,
				dt2,
				(long) TIEMOUT_2 - 1,
				(long) TIEMOUT_2 + 1);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_io_timeout_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_RX_IO_TIMEOUT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_io_timeout_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_RX_IO_TIMEOUT");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


