// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/rx_io_overflow.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AISS8AO4_IO_OVERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AISS8AO4_IO_OVERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_NDIV,
			/* arg		*/	45,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	0x3,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we got an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x8000
		},
		{				// Ignore the overflow
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AISS8AO4_IO_OVERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Select PIO mode.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_MODE,
			/* arg		*/	GSC_IO_MODE_PIO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AISS8AO4_IO_OVERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	u32	data[1];
	int	errs	= 0;
	int	ret;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	// Verify that IGNORE works.
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		ret	= aiss8ao4_read(fd, data, 4);

		if (ret != 4)
		{
			errs++;
			printf(	"FAIL <---  (%d. aiss8ao4_read(): returned %d, expected 4)\n",
					__LINE__,
					ret);
		}
	}

	// Verify that CHECK works.
	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		ret	= aiss8ao4_read(fd, data, 4);

		if (ret >= 0)
		{
			errs++;
			printf(	"FAIL <---  (%d. aiss8ao4_read(): returned %d, expected <= 0)\n",
					__LINE__,
					ret);
		}
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_io_overflow_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_RX_IO_OVERFLOW.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_io_overflow_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_RX_IO_OVERFLOW");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


