// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/reg_write.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const struct
	{
		u32	reg;
		u32	value;
		u32	mask;
	} list[]	=
	{
		// reg					value		mask
		{ AISS8AO4_GSC_IBTR,	0x0000AAAA,	0x0000FFFF	},
		{ AISS8AO4_GSC_IBTR,	0x00000005,	0x0000FFFF	},

		{ AISS8AO4_GSC_RGAR,	0x0002AAAA,	0x0001FFFF	},
		{ AISS8AO4_GSC_RGAR,	0x00000015,	0x0001FFFF	},
	};

	int			errs	= 0;
	int			i;
	gsc_reg_t	parm;
	int			ret;

	for (i = 0; i < SIZEOF_ARRAY(list); i++)
	{
		parm.reg	= list[i].reg;
		parm.value	= list[i].value;
		parm.mask	= 0xBEEFDEAD;
		ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_WRITE, (void*) &parm);

		if (ret)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, aiss8ao4_ioctl() failure, error %d)\n",
					__LINE__,
					i,
					ret);
			break;
		}

		if (parm.mask != 0xBEEFDEAD)
		{
			errs++;
			printf("FAIL <---  (%d. i %d, mask changed)\n", __LINE__, i);
			break;
		}

		// Now read the register and verify the bits of interest.
		ret	= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);

		if (ret)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, aiss8ao4_ioctl() failure, error %d)\n",
					__LINE__,
					i,
					ret);
			break;
		}

		if ((list[i].value & list[i].mask) != (parm.value & list[i].mask))
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, mask 0x%lX, got 0x%lX, expected 0x%lX)\n",
					__LINE__,
					i,
					(long) list[i].mask,
					(long) parm.value,
					(long) list[i].value);
			break;
		}
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	reg_write_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_REG_WRITE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int reg_write_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_REG_WRITE");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


