// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/reg_read.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const struct
	{
		u32	reg;
		u32	value;
	} list[]	=
	{
		// reg					value
		{ AISS8AO4_GSC_BCTLR,	0		},
		{ AISS8AO4_GSC_DIOPR,	0		},
		{ AISS8AO4_GSC_AOC0R,	0		},
		{ AISS8AO4_GSC_AOC1R,	0		},
		{ AISS8AO4_GSC_AOC2R,	0		},
		{ AISS8AO4_GSC_AOC3R,	0		},
		{ AISS8AO4_GSC_AIBR,	0		},
		{ AISS8AO4_GSC_RGAR,	0		},
		{ AISS8AO4_GSC_RGBR,	0		},
		{ AISS8AO4_GSC_AICR,	0		},
		{ AISS8AO4_GSC_IBSR,	0		},
		{ AISS8AO4_GSC_IBTR,	0		},
		{ AISS8AO4_GSC_ICSR,	0		},
		{ AISS8AO4_GSC_BCFGR,	0		},
		{ AISS8AO4_GSC_AVR,		0		},
		{ AISS8AO4_GSC_ARWR,	0		},

		{ GSC_PCI_9080_VIDR,	0x10B5	},
		{ GSC_PCI_9080_DIDR,	0x9080	},
		{ GSC_PCI_9080_SVID,	0x10B5	},
		{ GSC_PCI_9080_SID,		0x2880	},

		{ GSC_PLX_9080_VIDR,	0x10B5	},
		{ GSC_PLX_9080_DIDR,	0x9080	}
	};

	int			errs	= 0;
	int			i;
	gsc_reg_t	parm;
	int			ret;

	for (i = 0; i < SIZEOF_ARRAY(list); i++)
	{
		parm.reg	= list[i].reg;
		parm.value	= 0xDEADBEEF;
		parm.mask	= 0xBEEFDEAD;
		ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);

		if (ret)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, aiss8ao4_ioctl() failure, error %d)\n",
					__LINE__,
					i,
					ret);
			break;
		}

		if (parm.value == 0xDEADBEEF)
		{
			errs++;
			printf("FAIL <---  (%d. i %d, value not changed)\n", __LINE__, i);
			break;
		}

		if (parm.mask != 0xBEEFDEAD)
		{
			errs++;
			printf("FAIL <---  (%d. i %d, mask changed)\n", __LINE__, i);
			break;
		}

		if ((list[i].value) && (parm.value != list[i].value))
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, got 0x%lX, expected 0x%lX)\n",
					__LINE__,
					i,
					(long) parm.value,
					(long) list[i].value);
			break;
		}
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	reg_read_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_REG_READ.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int reg_read_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_REG_READ");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


