// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/query.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	s32	data;
	s32	count;
	int	errs	= 0;
	int	i;

	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_COUNT, &count);

	if (count != (AISS8AO4_IOCTL_QUERY_LAST))
	{
		errs++;
		printf(	"FAIL <---  (expected %ld, got %ld, rebuild application)\n",
				(long) AISS8AO4_IOCTL_QUERY_LAST,
				(long) count);
	}
	else
	{
		for (i = 0; (errs == 0) && (i <= AISS8AO4_IOCTL_QUERY_LAST); i++)
			errs	+= aiss8ao4_query(fd, -1, 0, i, &data);
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	query_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_QUERY.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int query_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_QUERY");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


