// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/perform.c $
// $Rev: 51903 $
// $Date: 2022-10-20 10:31:56 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= reg_read_tests(args->fd);		// AISS8AO4_IOCTL_REG_READ
	errs	+= reg_write_tests(args->fd);		// AISS8AO4_IOCTL_REG_WRITE
	errs	+= reg_mod_tests(args->fd);			// AISS8AO4_IOCTL_REG_MOD
	errs	+= query_tests(args->fd);			// AISS8AO4_IOCTL_QUERY
	errs	+= initialize_tests(args->fd);		// AISS8AO4_IOCTL_INITIALIZE
	errs	+= auto_calibrate_tests(args->fd);	// AISS8AO4_IOCTL_AUTO_CALIBRATE
	errs	+= auto_cal_sts_tests(args->fd);	// AISS8AO4_IOCTL_AUTO_CAL_STS

	errs	+= ai_buf_clear_tests(args->fd);	// AISS8AO4_IOCTL_AI_BUF_CLEAR
	errs	+= ai_buf_level_tests(args->fd);	// AISS8AO4_IOCTL_AI_BUF_LEVEL
	errs	+= ai_buf_overflow_tests(args->fd);	// AISS8AO4_IOCTL_AI_BUF_OVERFLOW
	errs	+= ai_buf_thr_lvl_tests(args->fd);	// AISS8AO4_IOCTL_AI_BUF_THR_LVL
	errs	+= ai_buf_thr_sts_tests(args->fd);	// AISS8AO4_IOCTL_AI_BUF_THR_STS
	errs	+= ai_burst_enable_tests(args->fd);	// AISS8AO4_IOCTL_AI_BURST_ENABLE
	errs	+= ai_burst_size_tests(args->fd);	// AISS8AO4_IOCTL_AI_BURST_SIZE
	errs	+= ai_burst_status_tests(args->fd);	// AISS8AO4_IOCTL_AI_BURST_STATUS
	errs	+= ai_chan_sel_tests(args->fd);		// AISS8AO4_IOCTL_AI_CHAN_SEL
	errs	+= ai_enable_tests(args->fd);		// AISS8AO4_IOCTL_AI_ENABLE
	errs	+= ai_mode_tests(args->fd);			// AISS8AO4_IOCTL_AI_MODE
	errs	+= ai_range_a_tests(args->fd);		// AISS8AO4_IOCTL_AI_RANGE_A
	errs	+= ai_range_b_tests(args->fd);		// AISS8AO4_IOCTL_AI_RANGE_B
	errs	+= ai_sw_clock_tests(args->fd);		// AISS8AO4_IOCTL_AI_SW_CLOCK
	errs	+= ai_sw_trigger_tests(args->fd);	// AISS8AO4_IOCTL_AI_SW_TRIGGER

	errs	+= ao_clock_mode_tests(args->fd);	// AISS8AO4_IOCTL_AO_CLOCK_MODE
	errs	+= ao_range_tests(args->fd);		// AISS8AO4_IOCTL_AO_RANGE
	errs	+= ao_sw_clock_tests(args->fd);		// AISS8AO4_IOCTL_AO_SW_CLOCK
	errs	+= ao_timing_tests(args->fd);		// AISS8AO4_IOCTL_AO_TIMING

	errs	+= data_format_tests(args->fd);		// AISS8AO4_IOCTL_DATA_FORMAT
	errs	+= dio_dir_out_tests(args->fd);		// AISS8AO4_IOCTL_DIO_DIR_OUT
	errs	+= dio_read_tests(args->fd);		// AISS8AO4_IOCTL_DIO_READ
	errs	+= dio_write_tests(args->fd);		// AISS8AO4_IOCTL_DIO_WRITE
	errs	+= gen_a_enable_tests(args->fd);	// AISS8AO4_IOCTL_GEN_A_ENABLE
	errs	+= gen_a_ndiv_tests(args->fd);		// AISS8AO4_IOCTL_GEN_A_NDIV
	errs	+= gen_b_enable_tests(args->fd);	// AISS8AO4_IOCTL_GEN_B_ENABLE
	errs	+= gen_b_ndiv_tests(args->fd);		// AISS8AO4_IOCTL_GEN_B_NDIV
	errs	+= irq_enable_tests(args->fd);		// AISS8AO4_IOCTL_IRQ_ENABLE
	errs	+= oper_mode_tests(args->fd);		// AISS8AO4_IOCTL_OPER_MODE

	errs	+= rx_io_abort_tests(args->fd);		// AISS8AO4_IOCTL_RX_IO_ABORT
	errs	+= rx_io_mode_tests(args->fd);		// AISS8AO4_IOCTL_RX_IO_MODE
	errs	+= rx_io_overflow_tests(args->fd);	// AISS8AO4_IOCTL_RX_IO_OVERFLOW
	errs	+= rx_io_timeout_tests(args->fd);	// AISS8AO4_IOCTL_RX_IO_TIMEOUT

	errs	+= wait_cancel_tests(args->fd);		// AISS8AO4_IOCTL_WAIT_CANCEL
	errs	+= wait_event_tests(args->fd);		// AISS8AO4_IOCTL_WAIT_EVENT
	errs	+= wait_status_tests(args->fd);		// AISS8AO4_IOCTL_WAIT_STATUS

	return(errs);
}


