// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/main.h $
// $Rev: 51903 $
// $Date: 2022-10-20 10:31:56 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "12aiss8ao4_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)				(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings
	s32		continuous;
	s32		index;
	s32		minute_limit;
	s32		test_limit;

	int		fd;

	// Device Settings
} args_t;

typedef enum
{
	SERVICE_END_LIST,	// Ends list of service_data_t structures.
	SERVICE_NORMAL,
	SERVICE_REG_MOD,
	SERVICE_REG_READ,
	SERVICE_REG_SHOW,
	SERVICE_REG_TEST,
	SERVICE_SLEEP,
	SERVICE_SLEEP_MS,
	SERVICE_IOCTL_GET,
	SERVICE_IOCTL_SET
} service_t;

typedef struct
{
	service_t		service;
	unsigned long	cmd;	// IOCTL code
	s32				arg;	// The IOCTL data argument.
	u32				reg;	// The register to access. Use -1 to ignore.
	u32				mask;	// The register bits of interest.
	u32				value;	// The value expected for the bits of interest.
} service_data_t;



// prototypes *****************************************************************

int	ai_buf_clear_tests(int fd);		// AISS8AO4_IOCTL_AI_BUF_CLEAR
int	ai_buf_level_tests(int fd);		// AISS8AO4_IOCTL_AI_BUF_LEVEL
int	ai_buf_overflow_tests(int fd);	// AISS8AO4_IOCTL_AI_BUF_OVERFLOW
int	ai_buf_thr_lvl_tests(int fd);	// AISS8AO4_IOCTL_AI_BUF_THR_LVL
int	ai_buf_thr_sts_tests(int fd);	// AISS8AO4_IOCTL_AI_BUF_THR_STS
int	ai_burst_enable_tests(int fd);	// AISS8AO4_IOCTL_AI_BURST_ENABLE
int	ai_burst_size_tests(int fd);	// AISS8AO4_IOCTL_AI_BURST_SIZE
int	ai_burst_status_tests(int fd);	// AISS8AO4_IOCTL_AI_BURST_STATUS
int	ai_chan_sel_tests(int fd);		// AISS8AO4_IOCTL_AI_CHAN_SEL
int	ai_enable_tests(int fd);		// AISS8AO4_IOCTL_AI_ENABLE
int	ai_mode_tests(int fd);			// AISS8AO4_IOCTL_AI_MODE
int	ai_range_a_tests(int fd);		// AISS8AO4_IOCTL_AI_RANGE_A
int	ai_range_b_tests(int fd);		// AISS8AO4_IOCTL_AI_RANGE_B
int	ai_sw_clock_tests(int fd);		// AISS8AO4_IOCTL_AI_SW_CLOCK
int	ai_sw_trigger_tests(int fd);	// AISS8AO4_IOCTL_AI_SW_TRIGGER

int	ao_clock_mode_tests(int fd);	// AISS8AO4_IOCTL_AO_CLOCK_MODE
int	ao_range_tests(int fd);			// AISS8AO4_IOCTL_AO_RANGE
int	ao_sw_clock_tests(int fd);		// AISS8AO4_IOCTL_AO_SW_CLOCK
int	ao_timing_tests(int fd);		// AISS8AO4_IOCTL_AO_TIMING

int	auto_cal_sts_tests(int fd);		// AISS8AO4_IOCTL_AUTO_CAL_STS
int	auto_calibrate_tests(int fd);	// AISS8AO4_IOCTL_AUTO_CALIBRATE

int	data_format_tests(int fd);		// AISS8AO4_IOCTL_DATA_FORMAT
int	dio_dir_out_tests(int fd);		// AISS8AO4_IOCTL_DIO_DIR_OUT
int	dio_read_tests(int fd);			// AISS8AO4_IOCTL_DIO_READ
int	dio_write_tests(int fd);		// AISS8AO4_IOCTL_DIO_WRITE

int	gen_a_enable_tests(int fd);		// AISS8AO4_IOCTL_GEN_A_ENABLE
int	gen_a_ndiv_tests(int fd);		// AISS8AO4_IOCTL_GEN_A_NDIV
int	gen_b_enable_tests(int fd);		// AISS8AO4_IOCTL_GEN_B_ENABLE
int	gen_b_ndiv_tests(int fd);		// AISS8AO4_IOCTL_GEN_B_NDIV

int	initialize_tests(int fd);		// AISS8AO4_IOCTL_INITIALIZE
int	irq_enable_tests(int fd);		// AISS8AO4_IOCTL_IRQ_ENABLE

int	oper_mode_tests(int fd);		// AISS8AO4_IOCTL_OPER_MODE

int	perform_tests(const args_t* args);

int	query_tests(int fd);			// AISS8AO4_IOCTL_QUERY

int	reg_mod_tests(int fd);			// AISS8AO4_IOCTL_REG_MOD
int	reg_read_tests(int fd);			// AISS8AO4_IOCTL_REG_READ
int	reg_write_tests(int fd);		// AISS8AO4_IOCTL_REG_WRITE
int	rx_io_abort_tests(int fd);		// AISS8AO4_IOCTL_RX_IO_ABORT
int	rx_io_mode_tests(int fd);		// AISS8AO4_IOCTL_RX_IO_MODE
int	rx_io_overflow_tests(int fd);	// AISS8AO4_IOCTL_RX_IO_OVERFLOW
int	rx_io_timeout_tests(int fd);	// AISS8AO4_IOCTL_RX_IO_TIMEOUT

int	service_ioctl_reg_get_list(int fd, const service_data_t* list);
int	service_ioctl_set_get_list(int fd, const service_data_t* list);
int	service_ioctl_set_reg_list(int fd, const service_data_t* list);

int	wait_cancel_tests(int fd);		// AISS8AO4_IOCTL_WAIT_CANCEL
int	wait_event_tests(int fd);		// AISS8AO4_IOCTL_WAIT_EVENT
int	wait_status_tests(int fd);		// AISS8AO4_IOCTL_WAIT_STATUS



#endif
