// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/irq_enable.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_IRQ_ENABLE,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_ICSR,
			/* mask		*/	0x1FF,
			/* value	*/	0x000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;
	int	i;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	for (i = 0; i <= 8; i++)
	{
		// Walking one.
		list[0].arg		= 0x1FF & (1 << i);
		list[0].value	= list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		// Walking zero.
		list[0].arg		= 0x1FF ^ (1 << i);
		list[0].value	= 0x1FF & list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(void)
{
	// These are tested elsewhere.
	return(0);
}



/******************************************************************************
*
*	Function:	irq_enable_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_IRQ_ENABLE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int irq_enable_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_IRQ_ENABLE");
	errs	+= _service_test(fd);
	errs	+= _function_test();

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


