// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/initialize.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{				// Perform the initialization.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x80000000,
			/* value	*/	0x00000000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{				// Adjust the input buffer threshold.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x7
		},
		{				// Perform the initialization and chech the results.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	initialize_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_INITIALIZE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int initialize_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_INITIALIZE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


