// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/gen_b_ndiv.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_B_NDIV,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_RGBR,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	s32	mask;
	s32	max;
	s32	min;
	s32	v;

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_NDIV_MASK, &mask);
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_NDIV_MAX, &max);
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_NDIV_MIN, &min);

	for (v = min; v < max; v++)
	{
		list[0].arg		= v;
		list[0].mask	= mask;
		list[0].value	= v;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(void)
{
	// This requires additional equipment to test.
	return(0);
}



/******************************************************************************
*
*	Function:	gen_b_ndiv_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_GEN_B_NDIV.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int gen_b_ndiv_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_GEN_B_NDIV");
	errs	+= _service_test(fd);
	errs	+= _function_test();

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


