// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/dio_read.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x01000100,
			/* value	*/	0x01000100
		},

		{ SERVICE_END_LIST }
	};

	service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x00FF00FF,
			/* value	*/	0x00000000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	s32	get;
	int	i;
	int	ret;
	s32	set;

	for (i = 0; i < 16; i++)
	{
		errs	+= aiss8ao4_initialize(fd, -1, 0);

		// Walking one.
		errs			+= service_ioctl_set_reg_list(fd, list_1);
		set				= 1 << i;
		list_2[0].value	= ((set << 8) & 0x00FF0000) | (set & 0xFF);
		errs			+= service_ioctl_set_reg_list(fd, list_2);
		ret				= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_DIO_READ, &get);
		errs			+= ret ? 1 : 0;

		if (set != get)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, set 0x%04lX != get 0x%04lX)\n",
					__LINE__,
					i,
					(long) set,
					(long) get);
		}

		// walking zero.
		errs			+= service_ioctl_set_reg_list(fd, list_1);
		set				= 0xFFFF ^ (1 << i);
		list_2[0].value	= ((set << 8) & 0x00FF0000) | (set & 0xFF);
		errs			+= service_ioctl_set_reg_list(fd, list_2);
		ret				= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_DIO_READ, &get);
		errs			+= ret ? 1 : 0;

		if (set != get)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, set 0x%04lX != get 0x%04lX)\n",
					__LINE__,
					i,
					(long) set,
					(long) get);
		}

		errs	+= aiss8ao4_initialize(fd, -1, 0);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(void)
{
	// This test is the same as the service test.
	return(0);
}



/******************************************************************************
*
*	Function:	dio_read_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_DIO_READ.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dio_read_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_DIO_READ");
	errs	+= _service_test(fd);
	errs	+= _function_test();

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


