// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/dio_dir_out.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DIO_DIR_OUT,
			/* arg		*/	0x0,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x01000100,
			/* value	*/	0x00000000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DIO_DIR_OUT,
			/* arg		*/	0x1,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x01000100,
			/* value	*/	0x00000100
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DIO_DIR_OUT,
			/* arg		*/	0x2,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x01000100,
			/* value	*/	0x01000000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DIO_DIR_OUT,
			/* arg		*/	0x3,
			/* reg		*/	AISS8AO4_GSC_DIOPR,
			/* mask		*/	0x01000100,
			/* value	*/	0x01000100
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(void)
{
	// This requires additional equipment to test.
	return(0);
}



/******************************************************************************
*
*	Function:	dio_dir_out_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_DIO_DIR_OUT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dio_dir_out_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_DIO_DIR_OUT");
	errs	+= _service_test(fd);
	errs	+= _function_test();

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


