// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/data_format.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_OFFB		0xF33				// Offset Binary: Output 9 v
#define	_OFFB_MAX	(0xF33 + 0x0FF)		// Offset Binary: Input 9 v
#define	_OFFB_MIN	(0xF33 - 0x0FF)		// Offset Binary: Input 9 v

#define	_TWOS		0xF33				// Offset Binary: Output 9 v
#define	_TWOS_MAX	(0x733 + 0x0FF)		// Twos Comp: Input 9 v
#define	_TWOS_MIN	(0x733 - 0x0FF)		// Twos Comp: Input 9 v



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_2S_COMP,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x02000000,
			/* value	*/	0x00000000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_OFF_BIN,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x02000000,
			/* value	*/	0x02000000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _format_test(
	int		fd,
	s32		format,
	s32		vout,
	long	min,
	long	max)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_OFF_BIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AUTO_CALIBRATE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC0R,
			/* mask		*/	0xFFF,
			/* value	*/	vout
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	format,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	gsc_reg_t	parm;
	int			ret;
	s32			value;

	errs		+= aiss8ao4_initialize(fd, -1, 0);
	errs		+= service_ioctl_set_reg_list(fd, list);
	parm.reg	= AISS8AO4_GSC_AIBR;
	parm.value	= 0xDEADBEEF;
	parm.mask	= 0xBEEFDEAD;
	ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
	value		= parm.value & 0xFFF;

	if (ret)
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
				__LINE__,
				ret);
	}
	else if ((value < min) || (value > max))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) min,
				(long) max);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int	errs	= 0;

	errs	+= _format_test(
				fd,
				AISS8AO4_DATA_FORMAT_OFF_BIN,
				_OFFB,
				_OFFB_MIN,
				_OFFB_MAX);

	errs	+= _format_test(
				fd,
				AISS8AO4_DATA_FORMAT_2S_COMP,
				_TWOS,
				_TWOS_MIN,
				_TWOS_MAX);
	return(errs);
}



/******************************************************************************
*
*	Function:	data_format_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_DATA_FORMAT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int data_format_tests(int fd)
{
	int	errs	= 0;
	s32	qty		= 0;

	gsc_label("AISS8AO4_IOCTL_DATA_FORMAT");
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_CHANNEL_AO_QTY, &qty);
	errs	+= _service_test(fd);

	if (qty > 0)
		errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


