// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/auto_cal_sts.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	// There are no persistant bits to test.
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AUTO_CALIBRATE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	ret;
	s32	sts		= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AUTO_CAL_STS, &sts);
	errs	+= ret ? 1 : 0;

	if ((errs == 0) && (sts != AISS8AO4_AUTO_CAL_STS_PASS))
	{
		errs++;
		printf("FAIL <---  (%d. status != PASS)\n", __LINE__);
	}

	errs	+= service_ioctl_set_reg_list(fd, list);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AUTO_CAL_STS, &sts);
	errs	+= ret ? 1 : 0;

	if ((errs == 0) && (sts != AISS8AO4_AUTO_CAL_STS_PASS))
	{
		errs++;
		printf("FAIL <---  (%d. status != PASS)\n", __LINE__);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	auto_cal_sts_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AUTO_CAL_STS.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int auto_cal_sts_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_AUTO_CAL_STS");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


