// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ao_timing.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_IMMED		0xF33				// Output 9 v on the 10 v output range
#define	_IMMED_MAX	(0xF33 + 0x0FF)		// Input 9 v on the 10 v input range
#define	_IMMED_MIN	(0xF33 - 0x0FF)		// Input 9 v on the 10 v input range

#define	_SIMUL		0x8CD				// Output 1 v on the 10 v output range
#define	_SIMUL_MAX	(0x8CD + 0x0FF)		// Input 1 v on the 10 v input range
#define	_SIMUL_MIN	(0x8CD - 0x0FF)		// Input 1 v on the 10 v input range



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_TIMING,
			/* arg		*/	AISS8AO4_AO_TIMING_IMMED,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x40000,
			/* value	*/	0x00000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_TIMING,
			/* arg		*/	AISS8AO4_AO_TIMING_SIMUL,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x40000,
			/* value	*/	0x40000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _immed_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_TIMING,
			/* arg		*/	AISS8AO4_AO_TIMING_IMMED,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_CLOCK_MODE,
			/* arg		*/	AISS8AO4_AO_CLOCK_MODE_ASYNC,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_OFF_BIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AUTO_CALIBRATE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC0R,
			/* mask		*/	0xFFF,
			/* value	*/	_IMMED
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	gsc_reg_t	parm;
	int			ret;
	s32			value;

	errs		+= service_ioctl_set_reg_list(fd, list);
	parm.reg	= AISS8AO4_GSC_AIBR;
	parm.value	= 0xDEADBEEF;
	parm.mask	= 0xBEEFDEAD;
	ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
	value		= parm.value & 0xFFF;

	if (ret)
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
				__LINE__,
				ret);
	}
	else if ((value < _IMMED_MIN) || (value > _IMMED_MAX))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) _IMMED_MIN,
				(long) _IMMED_MAX);
	}

	return(errs);
}



//*****************************************************************************
static int _simul_test(int fd)
{
	service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_TIMING,
			/* arg		*/	AISS8AO4_AO_TIMING_SIMUL,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC0R,
			/* mask		*/	0xFFF,
			/* value	*/	_SIMUL
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_SW_CLOCK,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	gsc_reg_t	parm;
	int			ret;
	s32			value;

	errs		+= service_ioctl_set_reg_list(fd, list_1);
	parm.reg	= AISS8AO4_GSC_AIBR;
	parm.value	= 0xDEADBEEF;
	parm.mask	= 0xBEEFDEAD;
	ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
	value		= parm.value & 0xFFF;

	if (ret)
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
				__LINE__,
				ret);
	}
	else if ((value < _IMMED_MIN) || (value > _IMMED_MAX))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) _IMMED_MIN,
				(long) _IMMED_MAX);
	}

	// Now clock out SIMUL value.

	errs		+= service_ioctl_set_reg_list(fd, list_2);
	parm.reg	= AISS8AO4_GSC_AIBR;
	parm.value	= 0xDEADBEEF;
	parm.mask	= 0xBEEFDEAD;
	ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
	value		= parm.value & 0xFFF;

	if (ret)
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
				__LINE__,
				ret);
	}
	else if ((value < _SIMUL_MIN) || (value > _SIMUL_MAX))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) _SIMUL_MIN,
				(long) _SIMUL_MAX);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int	errs	= 0;

	gsc_label_level_inc();
	errs	+= aiss8ao4_initialize(fd, -1, 0);
	errs	+= _immed_test(fd);
	errs	+= _simul_test(fd);
	errs	+= aiss8ao4_initialize(fd, -1, 0);
	gsc_label_level_dec();
	return(errs);
}



/******************************************************************************
*
*	Function:	ao_timing_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AO_TIMING.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ao_timing_tests(int fd)
{
	int	errs	= 0;
	s32	qty		= 0;

	gsc_label("AISS8AO4_IOCTL_AO_TIMING");
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_CHANNEL_AO_QTY, &qty);

	if (errs)
	{
		printf("FAIL <---  (aiss8ao4_query failed)\n");
	}
	else if (qty <= 0)
	{
		printf("SKIPPED  (No output channels on this device.)\n");
	}
	else
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}


