// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_range_a.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_100MV		0x829				// Output .05 v on the 2.5 output range
#define	_100MV_MAX	(0xC00 + 0x0FF)		// Input .05 v on the .1 v input range
#define	_100MV_MIN	(0xC00 - 0x0FF)		// Input .05 v on the .1 v input range

#define	_1V			0x99A				// Output .5 v on the 2.5 output range
#define	_1V_MAX		(0xC00 + 0x0FF)		// Input .5 v on the 1 v input range
#define	_1V_MIN		(0xC00 - 0x0FF)		// Input .5 v on the 1 v input range

#define	_10V		0xE66				// Output 2 v on the 2.5 output range
#define	_10V_MAX	(0x99A + 0x0FF)		// Input 2 v on the 10 v input range
#define	_10V_MIN	(0x99A - 0x0FF)		// Input 2 v on the 10 v input range



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_RANGE_A,
			/* arg		*/	AISS8AO4_AI_RANGE_100MV,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_RANGE_A,
			/* arg		*/	AISS8AO4_AI_RANGE_1V,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x10
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_RANGE_A,
			/* arg		*/	AISS8AO4_AI_RANGE_10V,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x20
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _range_test(int fd, s32 range, s32 vout, long min, long max)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_RANGE_A,
			/* arg		*/	range,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AO_RANGE,
			/* arg		*/	AISS8AO4_AO_RANGE_2_5V,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_OFF_BIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AUTO_CALIBRATE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC0R,
			/* mask		*/	0xFFF,
			/* value	*/	vout
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	int			i;
	gsc_reg_t	parm;
	int			ret;
	s32			value;

	errs		+= aiss8ao4_initialize(fd, -1, 0);
	errs		+= service_ioctl_set_reg_list(fd, list);

	for (i = 0; i < 10; i++)
	{
		parm.reg	= AISS8AO4_GSC_AIBR;
		parm.value	= 0xDEADBEEF;
		parm.mask	= 0xBEEFDEAD;
		ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
		value		= parm.value & 0xFFF;

		if (ret)
		{
			errs++;
			printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
					__LINE__,
					ret);
		}

		if ((value >= min) && (value <= max))
			break;
	}

	if ((errs == 0) && ((value < min) || (value > max)))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) min,
				(long) max);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _100mv_test(int fd)
{
	int	errs;

	errs	= _range_test(
				fd,
				AISS8AO4_AI_RANGE_100MV,
				_100MV,
				_100MV_MIN,
				_100MV_MAX);
	return(errs);
}



//*****************************************************************************
static int _1v_test(int fd)
{
	int	errs;

	errs	= _range_test(
				fd,
				AISS8AO4_AI_RANGE_1V,
				_1V,
				_1V_MIN,
				_1V_MAX);
	return(errs);
}



//*****************************************************************************
static int _10v_test(int fd)
{
	int	errs;

	errs	= _range_test(
				fd,
				AISS8AO4_AI_RANGE_10V,
				_10V,
				_10V_MIN,
				_10V_MAX);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, s32 qty)
{
	int	errs	= 0;

	if (qty)
	{
		errs	+= _100mv_test(fd);
		errs	+= _1v_test(fd);
		errs	+= _10v_test(fd);
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	ai_range_a_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_RANGE_A.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_range_a_tests(int fd)
{
	int	errs	= 0;
	s32	qty		= 0;

	gsc_label("AISS8AO4_IOCTL_AI_RANGE_A");
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_CHANNEL_AO_QTY, &qty);
	errs	+= _service_test(fd);
	errs	+= _function_test(fd, qty);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


