// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_mode.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	OUT0		0xCF3
#define	OUT1		0xAF9
#define	OUT2		0x507
#define	OUT3		0x30D
#define	VREF		0xFEC
#define	ZERO		0x800

#define	OUT0_MAX	(OUT0 + 0xFF)
#define	OUT0_MIN	(OUT0 - 0xFF)
#define	OUT1_MAX	(OUT1 + 0xFF)
#define	OUT1_MIN	(OUT1 - 0xFF)
#define	OUT2_MAX	(OUT2 + 0xFF)
#define	OUT2_MIN	(OUT2 - 0xFF)
#define	OUT3_MAX	(OUT3 + 0xFF)
#define	OUT3_MIN	(OUT3 - 0xFF)
#define	VREF_MAX	(VREF + 0xFF)
#define	VREF_MIN	(VREF - 0xFF)
#define	ZERO_MAX	(ZERO + 0xFF)
#define	ZERO_MIN	(ZERO - 0xFF)



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_DIFF,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_SINGLE,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x1
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_ZERO,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x2
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_VREF,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x4
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_1,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x5
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_2,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x6
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	AISS8AO4_AI_MODE_AO_3,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x7,
			/* value	*/	0x7
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _mode_test(int fd, s32 mode, long min, long max)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_MODE,
			/* arg		*/	mode,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_DATA_FORMAT,
			/* arg		*/	AISS8AO4_DATA_FORMAT_OFF_BIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AUTO_CALIBRATE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC0R,
			/* mask		*/	0xFFF,
			/* value	*/	OUT0
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC1R,
			/* mask		*/	0xFFF,
			/* value	*/	OUT1
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC2R,
			/* mask		*/	0xFFF,
			/* value	*/	OUT2
		},
		{
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_AOC3R,
			/* mask		*/	0xFFF,
			/* value	*/	OUT3
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP_MS,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	gsc_reg_t	parm;
	int			ret;
	s32			value;

	errs		+= aiss8ao4_initialize(fd, -1, 0);
	errs		+= service_ioctl_set_reg_list(fd, list);
	parm.reg	= AISS8AO4_GSC_AIBR;
	parm.value	= 0xDEADBEEF;
	parm.mask	= 0xBEEFDEAD;
	ret			= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_REG_READ, (void*) &parm);
	value		= parm.value & 0xFFF;

	if (ret)
	{
		errs++;
		printf(	"FAIL <---  (%d. aiss8ao4_ioctl() failure, error %d)\n",
				__LINE__,
				ret);
	}
	else if ((value < min) || (value > max))
	{
		errs++;
		printf(	"FAIL <---  (%d. range error: 0x%03lX, min 0x%lX, max 0x%lX)\n",
				__LINE__,
				(long) value,
				(long) min,
				(long) max);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	return(errs);
}



//*****************************************************************************
static int _zero_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_ZERO,
				ZERO_MIN,
				ZERO_MAX);
	return(errs);
}



//*****************************************************************************
static int _vref_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_VREF,
				VREF_MIN,
				VREF_MAX);
	return(errs);
}



//*****************************************************************************
static int _out0_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_AO_0,
				OUT0_MIN,
				OUT0_MAX);
	return(errs);
}



//*****************************************************************************
static int _out1_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_AO_1,
				OUT1_MIN,
				OUT1_MAX);
	return(errs);
}



//*****************************************************************************
static int _out2_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_AO_2,
				OUT2_MIN,
				OUT2_MAX);
	return(errs);
}



//*****************************************************************************
static int _out3_test(int fd)
{
	int	errs;

	errs	= _mode_test(
				fd,
				AISS8AO4_AI_MODE_AO_3,
				OUT3_MIN,
				OUT3_MAX);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, s32 qty)
{
	int	errs	= 0;

	errs	+= _zero_test(fd);
	errs	+= _vref_test(fd);

	if (qty > 0)
		errs	+= _out0_test(fd);

	if (qty > 1)
		errs	+= _out1_test(fd);

	if (qty > 2)
		errs	+= _out2_test(fd);

	if (qty > 3)
		errs	+= _out3_test(fd);

	return(errs);
}



/******************************************************************************
*
*	Function:	ai_mode_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_MODE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_mode_tests(int fd)
{
	int	errs	= 0;
	s32	qty;

	gsc_label("AISS8AO4_IOCTL_AI_MODE");
	errs	+= _service_test(fd);
	errs	+= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_CHANNEL_AO_QTY, &qty);
	errs	+= _function_test(fd, qty);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


