// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_burst_status.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	// There are no persistent bits to test with this service.
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_ENABLE,
			/* arg		*/	AISS8AO4_BURST_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	10,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	0x1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Fsamp = 36,000,000 / 65535 = 549 S/S
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_NDIV,
			/* arg		*/	0xFFFF,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_B_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_NO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	service_data_t	list_2[]	=
	{

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	service_data_t	list_3[]	=
	{
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	ret;
	s32	sts;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list_1);
	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BURST_STATUS, &sts);

	if (ret)
	{
			errs++;
	}
	else if (sts != AISS8AO4_BURST_STATUS_READY)
	{
		errs++;
		printf(	"FAIL <---  (%d. 1: expected %d, got %ld)\n",
				__LINE__,
				AISS8AO4_BURST_STATUS_READY,
				(long) sts);
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);
	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BURST_STATUS, &sts);

	if (ret)
	{
			errs++;
	}
	else if (sts != AISS8AO4_BURST_STATUS_NOT_READY)
	{
		errs++;
		printf(	"FAIL <---  (%d. 2: expected %d, got %ld)\n",
				__LINE__,
				AISS8AO4_BURST_STATUS_NOT_READY,
				(long) sts);
	}

	errs	+= service_ioctl_set_reg_list(fd, list_3);
	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BURST_STATUS, &sts);

	if (ret)
	{
			errs++;
	}
	else if (sts != AISS8AO4_BURST_STATUS_READY)
	{
		errs++;
		printf(	"FAIL <---  (%d. 3: expected %d, got %ld)\n",
				__LINE__,
				AISS8AO4_BURST_STATUS_READY,
				(long) sts);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	ai_burst_status_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_BURST_STATUS.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_burst_status_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_AI_BURST_STATUS");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


