// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_burst_size.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000000,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000000
		},

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000001,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000001
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000002,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000002
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000004,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000004
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000008,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000008
		},

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000010,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000010
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000020,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000020
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000040,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000040
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000080,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000080
		},

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000100,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000100
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000200,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000200
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000400,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000400
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x00000800,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x00000800
		},

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0x0000FFFF,
			/* reg		*/	AISS8AO4_GSC_AICR,
			/* mask		*/	0x0000FFFF,
			/* value	*/	0x0000FFFF
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	service_data_t	list[]	=
	{
		{	// 0			// Initialize the device.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 1			// Enable bursting.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_ENABLE,
			/* arg		*/	AISS8AO4_BURST_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 2			// Set the burst size.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	0,	// SET THIS FOR EACH LOOP ITERATION.
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 3			// Scan a single channel only.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 4			// Configure Rate-A Generator
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_NDIV,
			/* arg		*/	45,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 5			// Enable Rate-A Generator
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 6			// Disable Rate-B Generator
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_B_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_NO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 7		// Clear the buffer.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 8		// Enable input clocking.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 9			// Initiate a trigger.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 10			// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 11			// Verify the amount of data.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_IBSR,
			/* mask		*/	0xFFFF,
			/* value	*/	0	// SET IN EACH LOOP ITERATION
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	// We're only testing the level accuracy for a small range.

	for (i = 5; (errs == 0) && (i < 10); i++)
	{
		list[2].arg		= 111 * i;
		list[11].value	= 111 * i;
		errs			+= service_ioctl_set_reg_list(fd, list);
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	ai_burst_size_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_BURST_SIZE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_burst_size_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_AI_BURST_SIZE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


