// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_buf_thr_lvl.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_THR_LVL,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_IBTR,
			/* mask		*/	0xFFFF,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;
	int	i;

	for (i = 0; i <= 15; i++)
	{
		// Walking one.
		list[0].arg		= 1 << i;
		list[0].value	= 1 << i;

		errs	+= aiss8ao4_initialize(fd, -1, 0);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= aiss8ao4_initialize(fd, -1, 0);

		// Walking zero.
		list[0].arg		= 0xFFFF ^ (1 << i);
		list[0].value	= 0xFFFF ^ (1 << i);

		errs	+= aiss8ao4_initialize(fd, -1, 0);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= aiss8ao4_initialize(fd, -1, 0);
	}
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_NDIV,
			/* arg		*/	90,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	0x1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	100,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_ENABLE,
			/* arg		*/	AISS8AO4_BURST_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_CLEAR,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that the FIFO is empty.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_IBSR,
			/* mask		*/	0x1FFFF,
			/* value	*/	0x00000
		},

		// Test with 100 samples.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that the FIFO has samples.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_IBSR,
			/* mask		*/	0x1FFFF,
			/* value	*/	0x00064
		},
		{					// Set and test the threshold level.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_THR_LVL,
			/* arg		*/	99,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x4000,
			/* value	*/	0x4000
		},
		{					// Set and test the threshold level.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_THR_LVL,
			/* arg		*/	100,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x4000,
			/* value	*/	0x0000
		},

		// Test with 200 samples.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that the FIFO has samples.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_IBSR,
			/* mask		*/	0x1FFFF,
			/* value	*/	0x000C8
		},
		{					// Set and test the threshold level.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_THR_LVL,
			/* arg		*/	199,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x4000,
			/* value	*/	0x4000
		},
		{					// Set and test the threshold level.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_THR_LVL,
			/* arg		*/	200,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x4000,
			/* value	*/	0x0000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	ai_buf_thr_lvl_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_BUF_THR_LVL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_buf_thr_lvl_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_AI_BUF_THR_LVL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


