// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/sbtest/ai_buf_overflow.c $
// $Rev: 51900 $
// $Date: 2022-10-20 10:02:06 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(void)
{
	// There are no persistent bits to test with this service.
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		// Fill the FIFO.

		// Force a buffer overflow.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_NDIV,
			/* arg		*/	45,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_GEN_A_ENABLE,
			/* arg		*/	AISS8AO4_GEN_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	0x3,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_NO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we got an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x8000
		},

		// Now verify and clear the results.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_CHAN_SEL,
			/* arg		*/	0x1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_ENABLE,
			/* arg		*/	AISS8AO4_BURST_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_ENABLE,
			/* arg		*/	AISS8AO4_AIO_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Manually clear the overflow.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x0000
		},
		{					// Verify that there is no overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x0000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BURST_SIZE,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_SW_TRIGGER,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that there is an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x8000
		},
		{				// Verify that IGNORE changes nothing.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_OVERFLOW,
			/* arg		*/	AISS8AO4_BUF_OVERFLOW_IGNORE,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x8000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_3[]	=
	{
		{				// Verify that clear REMOVES THE STATUS.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AISS8AO4_IOCTL_AI_BUF_OVERFLOW,
			/* arg		*/	AISS8AO4_BUF_OVERFLOW_CLEAR,
			/* reg		*/	AISS8AO4_GSC_BCTLR,
			/* mask		*/	0x8000,
			/* value	*/	0x0000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	ret;
	s32	sts		= 0;

	errs	+= aiss8ao4_initialize(fd, -1, 0);

	// Verify that the status is NO overflow.
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		sts	= -1;
		ret	= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BUF_OVERFLOW, &sts);

		if (ret)
		{
			errs++;
		}
		else if (sts != AISS8AO4_BUF_OVERFLOW_NO)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow occurred but unexpected)\n",
					__LINE__);
		}
	}

	// Verify that the status IS an overflow.
	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		sts	= -1;
		ret	= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BUF_OVERFLOW, &sts);

		if (ret)
		{
			errs++;
		}
		else if (sts != AISS8AO4_BUF_OVERFLOW_YES)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow expected but did not occur)\n",
					__LINE__);
		}
	}

	// Verify that the status is NO overflow.
	errs	+= service_ioctl_set_reg_list(fd, list_3);

	if (errs == 0)
	{
		sts	= -1;
		ret	= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BUF_OVERFLOW, &sts);

		if (ret)
		{
			errs++;
		}
		else if (sts != AISS8AO4_BUF_OVERFLOW_NO)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow occurred but unexpected)\n",
					__LINE__);
		}
	}

	errs	+= aiss8ao4_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	ai_buf_overflow_tests
*
*	Purpose:
*
*		Perform a test of the IOCTL service AISS8AO4_IOCTL_AI_BUF_OVERFLOW.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai_buf_overflow_tests(int fd)
{
	int	errs	= 0;

	gsc_label("AISS8AO4_IOCTL_AI_BUF_OVERFLOW");
	errs	+= _service_test();
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


