// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/savedata/perform.c $
// $Rev: 51897 $
// $Date: 2022-10-20 10:00:29 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M		(1024L * 1024L)



// variables ******************************************************************

static	u32	_buffer[_1M];



//*****************************************************************************
static int _channels(const args_t* args)
{
	int	chans	= 0;
	int	errs;
	s32	get;
	int	i;
	int	ret;

	gsc_label("Input Channels");

	get			= -1;
	ret			= aiss8ao4_ioctl(args->fd, AISS8AO4_IOCTL_AI_CHAN_SEL,	&get);
	errs		= ret ? 1 : 0;

	for (i = 0; i < 31; i++)
	{
		if (get & (0x1L << i))
			chans++;
	}

	printf(	"%ld Channel%s  (0x%lX)\n",
			(long) chans,
			(chans == 1) ? "" : "s",
			(long) get);
	return(errs);
}



//*****************************************************************************
static int _read_data(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_buffer);
	int		got;

	gsc_label("Reading");
	got	= aiss8ao4_read(args->fd, _buffer, get);

	if (got < 0)
	{
		errs	= 1;
	}
	else if (got != get)
	{
		errs	= 1;
		printf(	"FAIL <---  (got %ld bytes, requested %ld)\n",
				(long) got,
				(long) get);
	}
	else
	{
		errs	= 0;
		printf(	"PASS  (%ld bytes)\n",
				(long) get);
	}

	return(errs);
}



//*****************************************************************************
static int _save_data(int errs)
{
	FILE*		file;
	int			i;
	long		l;
	const char*	name	= "data.txt";
	long		samples	= sizeof(_buffer) / 4;

	gsc_label("Saving");

	for (;;)
	{
		if (errs)
		{
			printf("SKIPPED  (errors)\n");
			errs	= 0;
			break;
		}

		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
			break;
		}

		for (l = 0; l < samples; l++)
		{
			if ((l) && ((_buffer[l] & 0xF0000) == 0))
			{
				i	= fprintf(file, "\r\n");

				if (i != 2)
				{
					printf("FAIL <---  (fprintf() failure to %s)\n", name);;
					errs	= 1;
					break;
				}
			}

			i	= fprintf(file, "  %08lX", (long) _buffer[l]);

			if (i != 10)
			{
				printf("FAIL <---  (fprintf() failure to %s)\n", name);
				errs	= 1;
				break;
			}
		}

		fclose(file);

		if (errs == 0)
			printf("PASS  (%s)\n", name);

		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Capture & Save");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss8ao4_config_ai(args->fd, -1, 1, 20000);
	errs	+= aiss8ao4_rx_io_mode(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= _channels(args);
	errs	+= aiss8ao4_ai_buf_clear(args->fd, -1, 1);
	errs	+= _read_data(args);
	errs	+= aiss8ao4_ai_buf_overflow(args->fd, -1, 1, -1, NULL);
	errs	+= _save_data(errs);

	gsc_label_level_dec();
	return(errs);
}



