// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/rxrate/perform.c $
// $Rev: 50266 $
// $Date: 2022-02-10 19:17:27 -0600 (Thu, 10 Feb 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M	(1024L * 1024L)



// variables ******************************************************************

static u32	_rx[_1M];



//*****************************************************************************
static int _rate_test(int seconds, long get, const args_t* args)
{
	struct timeval	begin;
	int				empty_count	= 0;
	int				errs		= 0;
	long			got;
	long long		limit		= (long long) args->rx_mb * 1000000L;
	struct timeval	minimum;
	struct timeval	now;
	long long		sps;
	long long		total		= 0;
	long			us			= 1000000L * seconds;

	gsc_label("Reading");

	gettimeofday(&begin, NULL);
	minimum.tv_sec	= begin.tv_sec + seconds;
	minimum.tv_usec	= begin.tv_usec;

	for (;;)
	{
		got	= aiss8ao4_read(args->fd, _rx, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <---  (aiss8ao4_read");
			printf(", total so far %lld", total);
			printf(", requested %ld bytes", (long) get);
			printf(", got %ld)\n", (long) got);
			break;
		}

		if (got == 0)
		{
			empty_count++;

			if (empty_count >= 10)
			{
				errs++;
				printf("FAIL <---  (aiss8ao4_read");
				printf(", too many empty read calls: %d)\n", empty_count);
				aiss8ao4_reg_list(args->fd, 1);
				break;
			}
		}

		gettimeofday(&now, NULL);
		total	+= got;

		if ((total >= limit) && (now.tv_sec > minimum.tv_sec))
		{
			us	= (now.tv_sec - begin.tv_sec) * 1000000L
				+ (now.tv_usec - begin.tv_usec);
			sps	= (total * 10000000L / 4 / us + 5) / 10;

			printf(	"PASS  (");
			gsc_label_long_comma(total / 4);
			printf(" Samples, %ld.%06ld Seconds, ", us / 1000000, us % 1000000);
			gsc_label_long_comma(sps);
			printf(" S/S)\n");
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_rx);
	int		seconds	= 5;

	errs	+= aiss8ao4_config_ai		(args->fd, -1, 1, 1000000L);
	errs	+= aiss8ao4_rx_io_mode		(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= aiss8ao4_rx_io_overflow	(args->fd, -1, 1, AISS8AO4_IO_OVERFLOW_IGNORE, NULL);

	gsc_label ("Read Rate");
	printf("(%d second minimum, %ld MB minimum)\n", seconds, (long) args->rx_mb);
	gsc_label_level_inc();

	errs	+= aiss8ao4_ai_buf_clear	(args->fd, -1, 1);
	errs	+= aiss8ao4_ai_buf_overflow	(args->fd, -1, 1, AISS8AO4_BUF_OVERFLOW_CLEAR, NULL);

	errs	+= _rate_test(seconds, get, args);

	errs	+= aiss8ao4_ai_buf_overflow	(args->fd, -1, 1, -1, NULL);

	gsc_label_level_dec();
	return(errs);
}



