// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/regs/perform.c $
// $Rev: 51901 $
// $Date: 2022-10-20 10:10:51 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_dump_everything
*
*	Purpose:
*
*		Dump all available data to the screen.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _dump_everything(int fd)
{
	os_id_host();
	printf("\n");
	os_id_driver(aiss8ao4_open, aiss8ao4_read, aiss8ao4_close);
	printf("\n");
	aiss8ao4_id_device(fd, -1, 1);
	printf("\n");
	gsc_reg_plx9080_list_pci(fd, aiss8ao4_reg_read);
	printf("\n");
	gsc_reg_plx9080_list_plx(fd, aiss8ao4_reg_read);
	printf("\n");
	aiss8ao4_reg_list(fd, 1);
}



/******************************************************************************
*
*	Function:	_dump_gsc
*
*	Purpose:
*
*		Dump the GSC registers.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _dump_gsc(int fd)
{
	aiss8ao4_reg_list(fd, 0);
}



/******************************************************************************
*
*	Function:	_dump_gsc_detail
*
*	Purpose:
*
*		Dump the GSC register details.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _dump_gsc_detail(int fd)
{
	aiss8ao4_reg_list(fd, 1);
}



/******************************************************************************
*
*	Function:	_dump_pci
*
*	Purpose:
*
*		Dump the PCI registers.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _dump_pci(int fd)
{
	gsc_reg_plx9080_list_pci(fd, aiss8ao4_reg_read);
}



/******************************************************************************
*
*	Function:	_dump_plx
*
*	Purpose:
*
*		Dump the PLX registers.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _dump_plx(int fd)
{
	gsc_reg_plx9080_list_plx(fd, aiss8ao4_reg_read);
}



/******************************************************************************
*
*	Function:	_id_device
*
*	Purpose:
*
*		Identify the device being accessed.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _id_device(int fd)
{
	aiss8ao4_id_device(fd, -1, 1);
}



/******************************************************************************
*
*	Function:	_id_driver
*
*	Purpose:
*
*		Identify the device driver.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _id_driver(int fd)
{
	os_id_driver(aiss8ao4_open, aiss8ao4_read, aiss8ao4_close);
}



/******************************************************************************
*
*	Function:	_id_host
*
*	Purpose:
*
*		Identify the host OS.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _id_host(int fd)
{
	os_id_host();
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Device Identification",			_id_device			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ "GSC Register Dump",				_dump_gsc			},
		{ "GSC Register Detail Dump",		_dump_gsc_detail	},
		{ "Edit GSC Register By Name",		reg_mod_by_name		},
		{ "Edit GSC Register By Offset",	reg_mod_by_offset	},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(args->fd, &menu);
	return(0);
}



