// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/id/perform.c $
// $Rev: 51893 $
// $Date: 2022-10-20 09:58:42 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _input_modes(void)
{
	gsc_label("Input Modes");
	printf("Differential, Single-Ended, Zero Test, +Vref Test, Chan 0/1/2/3 Loopback\n");
	return(0);
}



//*****************************************************************************
static int _voltage_ranges(void)
{
	gsc_label("Input Voltage Ranges");
	printf("+-10V, +-1V, +-0.1V\n");

	gsc_label("Output Voltage Ranges");
	printf("+-10V, +-5V, +-2.5V\n");
	return(0);
}



//*****************************************************************************
static int _clocking_sources(void)
{
	gsc_label("Clocking Sources");
	printf("Rate Generator(s), External, Software\n");
	return(0);
}



//*****************************************************************************
static int _sampling_modes(void)
{
	gsc_label("Input Sampling Modes");
	printf("Continuous, Burst\n");

	gsc_label("Output Update Modes");
	printf("Immediate, Synchronous\n");
	return(0);
}



//*****************************************************************************
static int _digital_io(void)
{
	gsc_label("Digital I/O");
	printf("16 Bi-Directional Signals (2 ports, 8-bits each)\n");
	return(0);
}



//*****************************************************************************
static int _id_device_bcfgr(const args_t* args)
{
	gsc_reg_def_t	list[2]	= { { NULL }, { NULL } };
	gsc_reg_def_t*	ptr;

	int	errs;

	printf("\n");
	ptr	= (gsc_reg_def_t*) aiss8ao4_reg_get_def_id(AISS8AO4_GSC_BCFGR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, aiss8ao4_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. aiss8ao4_reg_get_def_id, AISS8AO4_GSC_BCFGR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= aiss8ao4_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	errs	+= _input_modes();
	errs	+= _voltage_ranges();
	errs	+= _clocking_sources();
	errs	+= _sampling_modes();
	errs	+= _digital_io();

	for (i = 0; i < AISS8AO4_IOCTL_QUERY_LAST; i++)
		errs	+= aiss8ao4_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_bcfgr(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


