// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/din/perform.c $
// $Rev: 51891 $
// $Date: 2022-10-20 09:58:16 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#ifdef CLOCK_MONOTONIC_RAW
#define	CLOCK		CLOCK_MONOTONIC_RAW
#else
#ifdef CLOCK_MONOTONIC
#define	CLOCK		CLOCK_MONOTONIC
#else
#define	CLOCK		CLOCK_REALTIME
#endif
#endif



//*****************************************************************************
#ifndef	CLOCK_MONOTONIC_RAW
#define	clock_gettime(c,ts)	_my_clock_gettime(ts)

static int _my_clock_gettime(struct timespec* ts)
{
	int				ret;
	struct timeval	tv;

	if (ts)
	{
		ret	= 0;
		gettimeofday(&tv, NULL);
		ts->tv_sec	= tv.tv_sec;
		ts->tv_nsec	= tv.tv_usec * 1000;
	}
	else
	{
		ret	= 1;
	}

	return(ret);
}
#endif



//*****************************************************************************
static int _config(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Configuration");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss8ao4_initialize(args->fd, -1, 1);
	errs	+= aiss8ao4_dio_dir_out(args->fd, -1, 1, 0, NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static void _output_header(void)
{
	printf("\n");
	printf("    Seq   DIO In\n");
	printf("    No.   FEDC-BA98-7654-3210  Time Stamp      Delta         \n");
	printf("    ====  ===================  ==============  ==============\n");
}



//*****************************************************************************
static int _monitor(const args_t* args)
{
	u32				bit;
	int				bits	= 16;
	int				count	= 0;
	long long		delta;
	int				errs	= 0;
	int				i;
	s32				last	= -1;
	time_t			now;
	time_t			t_limit;
	struct timespec	t0;
	struct timespec	ts;
	struct timespec	ts_last;
	s32				value;

	gsc_label("Digital Input");
	printf("\n");
	gsc_label_level_inc();

	clock_gettime(CLOCK, &t0);
	clock_gettime(CLOCK, &ts);

	_output_header();
	t_limit	= time(NULL) + args->seconds + 1;

	for (; errs == 0;)
	{
		errs	= aiss8ao4_dio_read(args->fd, -1, 0, &value);

		if ((count <= 0) || (value != last))
		{
			ts_last	= ts;
			clock_gettime(CLOCK, &ts);

			if (count <= 0)
			{
				t0		= ts;
				ts_last	= ts;
			}

			count++;
			printf("    %-4d  ", count);

			for (i = bits - 1; i >= 0; i--)
			{
				if ((i == 11) || (i == 7) || (i == 3))
					printf(" ");

				bit	= 0x1 << i;
				printf("%s", (value & bit) ? "1" : "0");
			}

			delta	= (1000000000LL * ts.tv_sec + ts.tv_nsec)
					- (1000000000LL * t0.tv_sec + t0.tv_nsec);
			printf("  %4lld.%09lld", delta / 1000000000, delta % 1000000000);

			delta	= (1000000000LL * ts.tv_sec + ts.tv_nsec)
					- (1000000000LL * ts_last.tv_sec + ts_last.tv_nsec);
			printf("  %4lld.%09lld", delta / 1000000000, delta % 1000000000);

			printf("\n");
			fflush(stdout);
			last	= value;
		}

		now	= time(NULL);

		if (now >= t_limit)
			break;
	}

	printf("\n");
	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= _config(args);
	errs	+= _monitor(args);

	return(errs);
}


