// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/include/12aiss8ao4_utils.h $
// $Rev: 51889 $
// $Date: 2022-10-20 09:56:51 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Utilities: header file

#ifndef	__12AISS8AO4_UTILS_H__
#define	__12AISS8AO4_UTILS_H__

#include "12aiss8ao4_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	aiss8ao4_close_util			(int fd, int index, int verbose);
int aiss8ao4_init_util			(int verbose);
int aiss8ao4_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	aiss8ao4_open_util			(int device, int share, int index, int verbose, int* fd);
int	aiss8ao4_read_util			(int fd, int index, int verbose, void* dst, size_t bytes);

// IOCTL utility services

int	aiss8ao4_ai_buf_clear		(int fd, int index, int verbose);								// AISS8AO4_IOCTL_AI_BUF_CLEAR
int	aiss8ao4_ai_buf_level		(int fd, int index, int verbose, s32* get);						// AISS8AO4_IOCTL_AI_BUF_LEVEL
int	aiss8ao4_ai_buf_overflow	(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_BUF_OVERFLOW
int	aiss8ao4_ai_buf_thr_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_BUF_THR_LVL
int	aiss8ao4_ai_buf_thr_sts		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_BUF_THR_STS
int	aiss8ao4_ai_burst_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_BURST_ENABLE
int	aiss8ao4_ai_burst_size		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_BURST_SIZE
int	aiss8ao4_ai_burst_status	(int fd, int index, int verbose, s32* get);						// AISS8AO4_IOCTL_AI_BURST_STATUS
int	aiss8ao4_ai_chan_sel		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_CHAN_SEL
int	aiss8ao4_ai_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_ENABLE
int	aiss8ao4_ai_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_MODE
int	aiss8ao4_ai_range_a			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_RANGE_A
int	aiss8ao4_ai_range_b			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AI_RANGE_B
int	aiss8ao4_ai_sw_clock		(int fd, int index, int verbose);								// AISS8AO4_IOCTL_AI_SW_CLOCK
int	aiss8ao4_ai_sw_trigger		(int fd, int index, int verbose);								// AISS8AO4_IOCTL_AI_SW_TRIGGER
int	aiss8ao4_ao_clock_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AO_CLOCK_MODE
int	aiss8ao4_ao_range			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AO_RANGE
int	aiss8ao4_ao_sw_clock		(int fd, int index, int verbose);								// AISS8AO4_IOCTL_AO_SW_CLOCK
int	aiss8ao4_ao_timing			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_AO_TIMING
int	aiss8ao4_auto_cal_sts		(int fd, int index, int verbose, s32* get);						// AISS8AO4_IOCTL_AUTO_CAL_STS
int	aiss8ao4_auto_calibrate		(int fd, int index, int verbose);								// AISS8AO4_IOCTL_AUTO_CALIBRATE
int	aiss8ao4_data_format		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_DATA_FORMAT
int	aiss8ao4_dio_dir_out		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_DIO_DIR_OUT
int	aiss8ao4_dio_read			(int fd, int index, int verbose, s32* get);						// AISS8AO4_IOCTL_DIO_READ
int	aiss8ao4_dio_write			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_DIO_WRITE
int	aiss8ao4_gen_a_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_GEN_A_ENABLE
int	aiss8ao4_gen_a_ndiv			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_GEN_A_NDIV
int	aiss8ao4_gen_b_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_GEN_B_ENABLE
int	aiss8ao4_gen_b_ndiv			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_GEN_B_NDIV
int	aiss8ao4_initialize			(int fd, int index, int verbose);								// AISS8AO4_IOCTL_INITIALIZE
int	aiss8ao4_irq_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_IRQ_ENABLE
int	aiss8ao4_oper_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_OPER_MODE
int	aiss8ao4_query				(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_QUERY
int aiss8ao4_reg_mod			(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AISS8AO4_IOCTL_REG_MOD
int	aiss8ao4_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// AISS8AO4_IOCTL_REG_READ
int	aiss8ao4_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AISS8AO4_IOCTL_REG_WRITE
int	aiss8ao4_rx_io_abort		(int fd, int index, int verbose, s32* get);						// AISS8AO4_IOCTL_RX_IO_ABORT
int	aiss8ao4_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_RX_IO_MODE
int	aiss8ao4_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_RX_IO_OVERFLOW
int	aiss8ao4_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AISS8AO4_IOCTL_RX_IO_TIMEOUT
int	aiss8ao4_wait_cancel		(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS8AO4_IOCTL_WAIT_CANCEL
int	aiss8ao4_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS8AO4_IOCTL_WAIT_EVENT
int	aiss8ao4_wait_status		(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS8AO4_IOCTL_WAIT_STATUS

// Auxiliary utility services

int aiss8ao4_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	aiss8ao4_fsamp_ai_compute	(int fd, int index, int verbose, s32 fsamp, s32* ndiv, double* rate);
int	aiss8ao4_fsamp_ai_get		(int fd,			int verbose, s32* get);
int	aiss8ao4_fsamp_ai_report	(int fd, int index, int verbose, int chan, s32* fsamp);
int	aiss8ao4_fsamp_ai_report_all(int fd, int index, int verbose, s32* fsamp);
int aiss8ao4_id_device			(int fd, int index, int verbose);

int	aiss8ao4_count_boards		(int verbose, s32* get);
int	aiss8ao4_reg_list			(int fd, int detail);

const gsc_reg_def_t*			aiss8ao4_reg_get_def_id		(int reg);
const gsc_reg_def_t*			aiss8ao4_reg_get_def_index	(int index);
const char*						aiss8ao4_reg_get_desc		(int reg);
const char*						aiss8ao4_reg_get_name		(int reg);



#endif
