// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/driver/12aiss8ao4.h $
// $Rev: 51904 $
// $Date: 2022-10-20 10:38:02 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Device Driver: header file

#ifndef	__12AISS8AO4_H__
#define	__12AISS8AO4_H__

#include "gsc_common.h"
#include "gsc_pci9080.h"



// macros *********************************************************************

#define	AISS8AO4_BASE_NAME					"12aiss8ao4"

// IOCTL command codes
#define	AISS8AO4_IOCTL_REG_READ				OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	AISS8AO4_IOCTL_REG_WRITE			OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	AISS8AO4_IOCTL_REG_MOD				OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	AISS8AO4_IOCTL_QUERY				OS_IOCTL_RW( 3,  4, s32)
#define	AISS8AO4_IOCTL_INITIALIZE			OS_IOCTL   ( 4)
#define	AISS8AO4_IOCTL_AUTO_CALIBRATE		OS_IOCTL   ( 5)
#define	AISS8AO4_IOCTL_AUTO_CAL_STS			OS_IOCTL_R ( 6,  4, s32)
#define	AISS8AO4_IOCTL_AI_BUF_CLEAR			OS_IOCTL   ( 7)
#define	AISS8AO4_IOCTL_AI_BUF_LEVEL			OS_IOCTL_R ( 8,  4, s32)
#define	AISS8AO4_IOCTL_AI_BUF_OVERFLOW		OS_IOCTL_RW( 9,  4, s32)
#define	AISS8AO4_IOCTL_AI_BUF_THR_LVL		OS_IOCTL_RW(10,  4, s32)
#define	AISS8AO4_IOCTL_AI_BUF_THR_STS		OS_IOCTL_RW(11,  4, s32)
#define	AISS8AO4_IOCTL_AI_BURST_ENABLE		OS_IOCTL_RW(12,  4, s32)
#define	AISS8AO4_IOCTL_AI_BURST_SIZE		OS_IOCTL_RW(13,  4, s32)
#define	AISS8AO4_IOCTL_AI_BURST_STATUS		OS_IOCTL_RW(14,  4, s32)
#define	AISS8AO4_IOCTL_AI_CHAN_SEL			OS_IOCTL_RW(15,  4, s32)
#define	AISS8AO4_IOCTL_AI_ENABLE			OS_IOCTL_RW(16,  4, s32)
#define	AISS8AO4_IOCTL_AI_MODE				OS_IOCTL_RW(17,  4, s32)
#define	AISS8AO4_IOCTL_AI_RANGE_A			OS_IOCTL_RW(18,  4, s32)
#define	AISS8AO4_IOCTL_AI_RANGE_B			OS_IOCTL_RW(19,  4, s32)
#define	AISS8AO4_IOCTL_AI_SW_CLOCK			OS_IOCTL   (20)
#define	AISS8AO4_IOCTL_AI_SW_TRIGGER		OS_IOCTL   (21)
#define	AISS8AO4_IOCTL_AO_CLOCK_MODE		OS_IOCTL_RW(22,  4, s32)
#define	AISS8AO4_IOCTL_AO_RANGE				OS_IOCTL_RW(23,  4, s32)
#define	AISS8AO4_IOCTL_AO_SW_CLOCK			OS_IOCTL   (24)
#define	AISS8AO4_IOCTL_AO_TIMING			OS_IOCTL_RW(25,  4, s32)
#define	AISS8AO4_IOCTL_DATA_FORMAT			OS_IOCTL_RW(26,  4, s32)
#define	AISS8AO4_IOCTL_DIO_DIR_OUT			OS_IOCTL_RW(27,  4, s32)
#define	AISS8AO4_IOCTL_DIO_READ				OS_IOCTL_RW(28,  4, s32)
#define	AISS8AO4_IOCTL_DIO_WRITE			OS_IOCTL_RW(29,  4, s32)
#define	AISS8AO4_IOCTL_GEN_A_ENABLE			OS_IOCTL_RW(30,  4, s32)
#define	AISS8AO4_IOCTL_GEN_A_NDIV			OS_IOCTL_RW(31,  4, s32)
#define	AISS8AO4_IOCTL_GEN_B_ENABLE			OS_IOCTL_RW(32,  4, s32)
#define	AISS8AO4_IOCTL_GEN_B_NDIV			OS_IOCTL_RW(33,  4, s32)
#define	AISS8AO4_IOCTL_IRQ_ENABLE			OS_IOCTL_RW(34,  4, s32)
#define	AISS8AO4_IOCTL_OPER_MODE			OS_IOCTL_RW(35,  4, s32)
#define	AISS8AO4_IOCTL_RX_IO_MODE			OS_IOCTL_RW(36,  4, s32)
#define	AISS8AO4_IOCTL_RX_IO_OVERFLOW		OS_IOCTL_RW(37,  4, s32)
#define	AISS8AO4_IOCTL_RX_IO_TIMEOUT		OS_IOCTL_RW(38,  4, s32)
#define	AISS8AO4_IOCTL_RX_IO_ABORT			OS_IOCTL_R (39,  4, s32)
#define	AISS8AO4_IOCTL_WAIT_EVENT			OS_IOCTL_RW(40, 28, gsc_wait_t)
#define	AISS8AO4_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(41, 28, gsc_wait_t)
#define	AISS8AO4_IOCTL_WAIT_STATUS			OS_IOCTL_RW(42, 28, gsc_wait_t)

//*****************************************************************************
// AISS8AO4_IOCTL_REG_READ
// AISS8AO4_IOCTL_REG_WRITE
// AISS8AO4_IOCTL_REG_MOD
//
#define	AISS8AO4_REG_ENCODE(s,o)			GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	AISS8AO4_GSC_BCTLR					AISS8AO4_REG_ENCODE(4,0x00)// Board Control Register
#define	AISS8AO4_GSC_DIOPR					AISS8AO4_REG_ENCODE(4,0x04)// Digital I/O Port Register
#define	AISS8AO4_GSC_AOC0R					AISS8AO4_REG_ENCODE(4,0x08)// Anlog Output Channel 0 Register
#define	AISS8AO4_GSC_AOC1R					AISS8AO4_REG_ENCODE(4,0x0C)// Anlog Output Channel 1 Register
#define	AISS8AO4_GSC_AOC2R					AISS8AO4_REG_ENCODE(4,0x10)// Anlog Output Channel 2 Register
#define	AISS8AO4_GSC_AOC3R					AISS8AO4_REG_ENCODE(4,0x14)// Anlog Output Channel 3 Register
#define	AISS8AO4_GSC_AIBR					AISS8AO4_REG_ENCODE(4,0x18)// Analog Input Buffer Register
#define	AISS8AO4_GSC_RGAR					AISS8AO4_REG_ENCODE(4,0x1C)// Rate Generator A Register
#define	AISS8AO4_GSC_RGBR					AISS8AO4_REG_ENCODE(4,0x20)// Rate Generator B Register
#define	AISS8AO4_GSC_AICR					AISS8AO4_REG_ENCODE(4,0x24)// Analog Input Configuration Register
#define	AISS8AO4_GSC_IBSR					AISS8AO4_REG_ENCODE(4,0x28)// Input Buffer Size Register
#define	AISS8AO4_GSC_IBTR					AISS8AO4_REG_ENCODE(4,0x2C)// Input Buffer Threshold Register
#define	AISS8AO4_GSC_ICSR					AISS8AO4_REG_ENCODE(4,0x30)// Interrupt Control/Status Register
#define	AISS8AO4_GSC_BCFGR					AISS8AO4_REG_ENCODE(4,0x34)// Board Configuration Register
#define	AISS8AO4_GSC_AVR					AISS8AO4_REG_ENCODE(4,0x38)// Auto Cal Values Register
#define	AISS8AO4_GSC_ARWR					AISS8AO4_REG_ENCODE(4,0x3C)// Auto Cal Read/Write Register

//*****************************************************************************
// AISS8AO4_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AISS8AO4_QUERY_AUTO_CAL_MS,				// Max auto-cal period in ms.
	AISS8AO4_QUERY_CHANNEL_AI_MAX,			// Maximum number of input channels supported.
	AISS8AO4_QUERY_CHANNEL_AI_QTY,			// The number of input channels supported.
	AISS8AO4_QUERY_CHANNEL_AO_MAX,			// Maximum number of output channels supported.
	AISS8AO4_QUERY_CHANNEL_AO_QTY,			// The number of output channels supported.
	AISS8AO4_QUERY_COUNT,					// How many query options are supported?
	AISS8AO4_QUERY_DEVICE_TYPE,				// Value from gsc_dev_type_t
	AISS8AO4_QUERY_FGEN_MAX,				// Rate Generator maximum output rate.
	AISS8AO4_QUERY_FGEN_MIN,				// Rate Generator minimum output rate.
	AISS8AO4_QUERY_FIFO_SIZE_RX,			// Rx FIFO depth in 32-bit samples
	AISS8AO4_QUERY_FSAMP_MAX,				// The maximum sample rate per channel.
	AISS8AO4_QUERY_FSAMP_MIN,				// The minimum sample rate per channel.
	AISS8AO4_QUERY_INIT_MS,					// Max initialize period in ms.
	AISS8AO4_QUERY_MASTER_CLOCK,			// Master clock frequency
	AISS8AO4_QUERY_NDIV_MASK,				// Mask of valid Ndiv bits.
	AISS8AO4_QUERY_NDIV_MAX,				// Maximum rate generator Ndiv value.
	AISS8AO4_QUERY_NDIV_MIN,				// Maximum rate generator Ndiv value.
	AISS8AO4_QUERY_RATE_GEN_QTY,			// Number of Rate Generatorts.

	AISS8AO4_IOCTL_QUERY_LAST

} aiss8ao4_query_t;

#define	AISS8AO4_IOCTL_QUERY_ERROR			(-1)

//*****************************************************************************
// AISS8AO4_IOCTL_INITIALIZE				BCTLR D31
//
//	Parameter:	None

//*****************************************************************************
// AISS8AO4_IOCTL_AUTO_CALIBRATE			BCTLR D28
//
//	Parameter:	None

//*****************************************************************************
// AISS8AO4_IOCTL_AUTO_CAL_STS				BCTLR D29
//
//	Parameter:	s32*
//		One of the below values is returned.
#define	AISS8AO4_AUTO_CAL_STS_ACTIVE		0
#define	AISS8AO4_AUTO_CAL_STS_FAIL			1
#define	AISS8AO4_AUTO_CAL_STS_PASS			2

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BUF_CLEAR				BCTLR D13
//
//	Parameter:	None.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BUF_LEVEL				IBSR D0-D16
//
//	Parameter:	s32*
//		The value returned is the current buffer fill level.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BUF_OVERFLOW			BCTLR D15
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS8AO4_BUF_OVERFLOW_CLEAR			0
#define	AISS8AO4_BUF_OVERFLOW_IGNORE		(-1)

// For queries the following values are returned.
#define	AISS8AO4_BUF_OVERFLOW_NO			0
#define	AISS8AO4_BUF_OVERFLOW_YES			1

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BUF_THR_LVL			IBTR D0-D15
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BUF_THR_STS			BCTLR D14, IBTR D16
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS8AO4_AI_BUF_THR_STS_CLEAR		0
#define	AISS8AO4_AI_BUF_THR_STS_SET			1

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BURST_ENABLE			BCTLR D9
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS8AO4_BURST_ENABLE_NO			0
#define	AISS8AO4_BURST_ENABLE_YES			1

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BURST_SIZE				AICR D0-D15
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 0-0xFFFF.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_BURST_STATUS			BCTLR D10
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS8AO4_BURST_STATUS_READY			0
#define	AISS8AO4_BURST_STATUS_NOT_READY		1

//*****************************************************************************
// AISS8AO4_IOCTL_AI_CHAN_SEL				AICR D24-D31
//
//	Parameter:	s32*
//		Pass in a bitmap of the channels to enable, or
//		-1 to read the current setting.
//		A valid bitmap is dependent on the number of input channels on the
//		device.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_ENABLE					BCTLR D12
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS8AO4_AIO_ENABLE_NO				0	// Disable the buffer.
#define	AISS8AO4_AIO_ENABLE_YES				1	// Enable the buffer.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_MODE					BCTLR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_AI_MODE_DIFF				0	// Differential
#define	AISS8AO4_AI_MODE_SINGLE				1	// Single-Ended
#define	AISS8AO4_AI_MODE_ZERO				2	// Zero test
#define	AISS8AO4_AI_MODE_VREF				3	// Vref test
#define	AISS8AO4_AI_MODE_AO_0				4	// Analog Output Channel 0
#define	AISS8AO4_AI_MODE_AO_1				5	// Analog Output Channel 1
#define	AISS8AO4_AI_MODE_AO_2				6	// Analog Output Channel 2
#define	AISS8AO4_AI_MODE_AO_3				7	// Analog Output Channel 3

//*****************************************************************************
// AISS8AO4_IOCTL_AI_RANGE_A				BCTLR D4-D5
// AISS8AO4_IOCTL_AI_RANGE_B				BCTLR D6-D7
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_AI_RANGE_100MV				0	// +- 100m  volts
#define	AISS8AO4_AI_RANGE_1V				1	// +- 1 volt
#define	AISS8AO4_AI_RANGE_10V				2	// +- 10 volts

//*****************************************************************************
// AISS8AO4_IOCTL_AI_SW_CLOCK				BCTLR D8
// AISS8AO4_IOCTL_AO_SW_CLOCK				BCTLR D20
//
//	Parameter:	None.

//*****************************************************************************
// AISS8AO4_IOCTL_AI_SW_TRIGGER				BCTLR D11
//
//	Parameter:	None.

//*****************************************************************************
// AISS8AO4_IOCTL_AO_RANGE					BCTLR D16-D17
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_AO_RANGE_2_5V				0	// +- 2.5 volts
#define	AISS8AO4_AO_RANGE_5V				1	// +- 5 volts
#define	AISS8AO4_AO_RANGE_10V				2	// +- 10 volts

//*****************************************************************************
// AISS8AO4_IOCTL_AO_CLOCK_MODE				BCTLR D19
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_AO_CLOCK_MODE_ASYNC		0
#define	AISS8AO4_AO_CLOCK_MODE_SYNC			1

//*****************************************************************************
// AISS8AO4_IOCTL_AO_TIMING					BCTLR D18
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_AO_TIMING_IMMED			0
#define	AISS8AO4_AO_TIMING_SIMUL			1

//*****************************************************************************
// AISS8AO4_IOCTL_IRQ_ENABLE				ICSR D0-DD8
//
//	Parameter:	s32*
//		Pass in any combination of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_IRQ_AUTO_CAL_DONE			0x0001
#define	AISS8AO4_IRQ_AI_THRESH_H2L			0x0002
#define	AISS8AO4_IRQ_AI_THRESH_L2H			0x0004
#define	AISS8AO4_IRQ_AI_OVERFLOW			0x0008
#define	AISS8AO4_IRQ_AI_BURST_START			0x0010
#define	AISS8AO4_IRQ_AI_BURST_DONE			0x0020
#define	AISS8AO4_IRQ_AI_CLOCK				0x0040
#define	AISS8AO4_IRQ_AO_CLOCK				0x0080
#define	AISS8AO4_IRQ_DIO_0_L2H				0x0100
#define	AISS8AO4_IRQ_ALL					0x01FF

//*****************************************************************************
// AISS8AO4_IOCTL_OPER_MODE					BCTLR D24
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_OPER_MODE_TARG				0
#define	AISS8AO4_OPER_MODE_INIT				1

//*****************************************************************************
// AISS8AO4_IOCTL_DATA_FORMAT				BCTLR D25
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_DATA_FORMAT_2S_COMP		0	// Twos Compliment
#define	AISS8AO4_DATA_FORMAT_OFF_BIN		1	// Offset Binary

//*****************************************************************************
// AISS8AO4_IOCTL_DIO_DIR_OUT				DIOPR D8, D24
//
//	Parameter:	s32*
//		Pass in any value between the range of 0 to 0x3, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS8AO4_IOCTL_DIO_READ					DIOPR D0-D7, D16-D23
//
//	Parameter:	s32*
//		The value returned is in the range of 0 to 0xFFFF.

//*****************************************************************************
// AISS8AO4_IOCTL_DIO_WRITE					DIOPR D0-D7, D16-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 0 to 0xFFFF, or
//		-1 to read the current setting.
//		The value returned in the value read.

//*****************************************************************************
// AISS8AO4_IOCTL_GEN_A_ENABLE				BCTLR D26
// AISS8AO4_IOCTL_GEN_B_ENABLE				BCTLR D27
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_GEN_ENABLE_NO				0
#define	AISS8AO4_GEN_ENABLE_YES				1

//*****************************************************************************
// AISS8AO4_IOCTL_GEN_A_NDIV				RGAR D0-D15
// AISS8AO4_IOCTL_GEN_B_NDIV				RGBR D0-D15
//
//	Parameter:	s32*
//		Pass in any value in the range of 16 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS8AO4_IOCTL_RX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AISS8AO4_IO_MODE_DEFAULT			GSC_IO_MODE_PIO

//*****************************************************************************
// AISS8AO4_IOCTL_RX_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS8AO4_IO_OVERFLOW_DEFAULT		AISS8AO4_IO_OVERFLOW_CHECK
#define	AISS8AO4_IO_OVERFLOW_IGNORE			0
#define	AISS8AO4_IO_OVERFLOW_CHECK			1

//*****************************************************************************
// AISS8AO4_IOCTL_RX_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AISS8AO4_IO_TIMEOUT_DEFAULT			10
#define	AISS8AO4_IO_TIMEOUT_NO_SLEEP		0
#define	AISS8AO4_IO_TIMEOUT_MIN				0
#define	AISS8AO4_IO_TIMEOUT_MAX				GSC_IO_TIMEOUT_MAX
#define	AISS8AO4_IO_TIMEOUT_INFINITE		GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AISS8AO4_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS8AO4_IO_ABORT_NO				0
#define	AISS8AO4_IO_ABORT_YES				1

//*****************************************************************************
// AISS8AO4_IOCTL_WAIT_EVENT				all fields must be valid
// AISS8AO4_IOCTL_WAIT_CANCEL				fields need not be valid
// AISS8AO4_IOCTL_WAIT_STATUS				fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	AISS8AO4_WAIT_GSC_AUTO_CAL_DONE		AISS8AO4_IRQ_AUTO_CAL_DONE
#define	AISS8AO4_WAIT_GSC_AI_THRESH_H2L		AISS8AO4_IRQ_AI_THRESH_H2L
#define	AISS8AO4_WAIT_GSC_AI_THRESH_L2H		AISS8AO4_IRQ_AI_THRESH_L2H
#define	AISS8AO4_WAIT_GSC_AI_OVERFLOW		AISS8AO4_IRQ_AI_OVERFLOW
#define	AISS8AO4_WAIT_GSC_AI_BURST_START	AISS8AO4_IRQ_AI_BURST_START
#define	AISS8AO4_WAIT_GSC_AI_BURST_DONE		AISS8AO4_IRQ_AI_BURST_DONE
#define	AISS8AO4_WAIT_GSC_AI_CLOCK			AISS8AO4_IRQ_AI_CLOCK
#define	AISS8AO4_WAIT_GSC_AO_CLOCK			AISS8AO4_IRQ_AO_CLOCK
#define	AISS8AO4_WAIT_GSC_DIO_0_L2H			AISS8AO4_IRQ_DIO_0_L2H
#define	AISS8AO4_WAIT_GSC_ALL				AISS8AO4_IRQ_ALL

// gsc_wait_t.alt flags
#define	AISS8AO4_WAIT_ALT_ALL				0x0000
// gsc_wait_t.io
#define	AISS8AO4_WAIT_IO_RX_ABORT			0x0001
#define	AISS8AO4_WAIT_IO_RX_DONE			0x0002
#define	AISS8AO4_WAIT_IO_RX_ERROR			0x0004
#define	AISS8AO4_WAIT_IO_RX_TIMEOUT			0x0008
#define	AISS8AO4_WAIT_IO_ALL				0x000F

#endif
