// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/driver/main.h $
// $Rev: 51904 $
// $Date: 2022-10-20 10:38:02 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Device Driver: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include "12aiss8ao4.h"

#define	DEV_BAR_SHOW						0
#define	DEV_METRICS_SHOW					0
#define	DEV_PCI_ID_SHOW						0
#define	DEV_SUPPORTS_IRQ
#define	DEV_SUPPORTS_READ
#define	DEV_SUPPORTS_WAIT
#define	GSC_ALT_DEV_GET(a)					(a)
#define	GSC_ALT_STRUCT_GET(i,d)				(d)
#define	GSC_ALT_STRUCT_T					dev_data_t
#define	GSC_DEVS_PER_BOARD					1
#define	GSC_READ_PIO_PER_1MS				842				// number of hardware register reads per ms

typedef struct _dev_data_t					dev_data_t;

#include "gsc_main.h"



// macros *********************************************************************

#define	DEV_MODEL							"12AISS8AO4"	// Upper case form of the below.
#define	DEV_NAME							"12aiss8ao4"	// MUST AGREE WITH AISS8AO4_BASE_NAME

#define	DEV_VERSION							"4.6"			// FOR DEVICE SPECIFIC CODE ONLY!
// 4.6	Updated comments for consistency.
//		Standardized various IOCTL system log messages.
//		Standardized processing of the initialization IOCTL service.
//		Standardized processing of the autocalibration IOCTL service.
//		Updated per file reorganization.
// 4.5	Added support for the 5.x kernel series.
//		Updated initial file content for consistency.
//		Updated for porting to Windows.
//		Standardized various IOCTL system log messages.
//		Standardized processing of the initialization IOCTL service.
//		Standardized processing of the autocalibration IOCTL service.
// 4.4	Removed extraneous debug print statements from the read service.
// 4.3	Updated per changes to common code.
//		Made corrections to DMDMA support.
// 4.2	Bug fix: was ignoring BAR setup return value.
//		Updated per changes to the OS specific PCI services.
//		Made updates for DEV_SUPPORTS_XXX macro changes.
//		Modified code so open succeeds even if initialization fails.
//		Implemented support for PIO with improved efficiency.
// 4.1	The BAR code has been updated to include the data under a single structure.
//		The register definitions have been updated.
//		I/O services now pass around an os_mem_t structure instead of a buffer pointer.
//		White space cleanup.
//		Changed the arbitrary wait event callback argument to a void* type.
//		Modified to allow multiple apps to simultaneously access a single device.
//		Correct access to BAR0 and BAR1 (is RO, was RW).
//		Added an infinite I/O timeout option.
//		Corrected the IOCTL code for the register write and mod services.
// 4.0	Updated to use the newer common driver sources.
//		Removed GNU notice from non-Linux specific files.
//		Removed Linux specific content from non-Linux specific source files.
//		White space cleanup.
//		Now using a spinlock rather than enabling and disabling interrupts.
//		Updated gsc_irq_open() and gsc_irq_close().
//		Updated gsc_dma_open() and gsc_dma_close().
// 3.8	Reduced #include list in driver interface header.
// 3.7	Updated for the 3.x kernel.
//		Corrected a system time count roll over bug in ioctl.c.
// 3.6	BAR0 and BAR2 are now the only BAR regions used.
//		Include all common source, though not all are used.
// 3.5	Eliminated the global dev_check_id() routine.
//		Removed compiler warning under Fedora 15.
// 3.4	Implemented support for the common PIO I/O routines.
//		Changed use of DEV_SUPPORTS_PROC_ID_STR macro.
//		Changed use of DEV_SUPPORTS_READ macro.
//		Changed use of DEV_SUPPORTS_WRITE macro.
//		Changed use of DEV_IO_AUTO_START macro.
// 3.3	Added DMDMA support.
// 3.2	Overhauled IOCTL based local interrupt implementation.
//		Updated per changes to the common source code.
//		: Added DEV_IO_AUTO_START macro - auto-start not support.
//		: Added DEV_SUPPORTS_PROC_ID_STR macro - not supported.
//		: Implemented IOCTL based I/O Abort support.
//		: Implemented IOCTL based event/interrupt wait support.
//		: Implemented explicit local interrupt support.
// 3.1	Removed an extraneous printk() statement.
//		Fixed a bug in the DMA data availability count calculation.
//		Removed some unused macros.
// 3.0	Overhauled driver.
// 2.2	Fixed the IOCTL_DEVICE_SET_ANALOG_OUTPUT service.
//		BAR mapping is done for the exact size of the region.
// 2.1	Ported to the kernels through 2.6.27.
// 2.0	Updated kernel support.
//		Updated to use a more stable code base.
//		Updated to use similar call formatting as the other GSC Linux drivers.
// 1.1	Fixed bug in the AISS8AO4_IOCTL_AI_THRESH_STS service.
// 1.0	Initial release.
// BETA.0	Preliminary release of the new driver.

// I/O services
#define	DEV_IO_STREAM_QTY					(DEV_IO_RX_STREAM_QTY + DEV_IO_TX_STREAM_QTY)
#define	DEV_IO_RX_STREAM_QTY				1
#define	DEV_IO_TX_STREAM_QTY				0

#define	GSC_READ_PIO_WORK_32_BIT

// WAIT services
#define	DEV_WAIT_GSC_ALL					AISS8AO4_WAIT_GSC_ALL
#define	DEV_WAIT_ALT_ALL					AISS8AO4_WAIT_ALT_ALL
#define	DEV_WAIT_IO_ALL						AISS8AO4_WAIT_IO_ALL



// data types *****************************************************************

struct _dev_io_t
{
	// Initialized by open and IOCTL services (initialize and/or service specific).

	s32					io_mode;			// PIO, DMA, DMDMA
	s32					overflow_check;		// Check overflow when reading?
	s32					pio_threshold;		// Use PIO if samples <= this.
	s32					timeout_s;			// I/O timeout in seconds.

	// Initialized by I/O service at time of use.

	int					abort;
	gsc_dma_ch_t*		dma_channel;		// Use this channel for DMA.
	int					non_blocking;		// Is this non-blocking I/O?

	// Initialized by device specific I/O create code.

	int					bytes_per_sample;	// Sample size in bytes.
	u32					io_reg_offset;		// Offset of device's I/O FIFO.
	VADDR_T				io_reg_vaddr;		// Address of device's I/O FIFO.

	void				(*dev_io_sw_init)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	void				(*dev_io_close)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	void				(*dev_io_open)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	int					(*dev_io_startup)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io);
	long				(*dev_pio_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_bmdma_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_dmdma_available)	(GSC_ALT_STRUCT_T* alt, dev_io_t* io, size_t count);
	long				(*dev_pio_xfer)			(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
	long				(*dev_bmdma_xfer)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
	long				(*dev_dmdma_xfer)		(GSC_ALT_STRUCT_T* alt, dev_io_t* io, const os_mem_t* mem, size_t count, os_time_tick_t st_end);

	struct
	{
		u32				abort;		// ...WAIT_IO_XXX_ABORT
		u32				done;		// ...WAIT_IO_XXX_DONE
		u32				error;		// ...WAIT_IO_XXX_ERROR
		u32				timeout;	// ...WAIT_IO_XXX_TIMEOUT
	} wait;

	// Initialize by GSC commone create code.

	os_sem_t			sem;				// Only one Tx or Rx at a time.
	os_mem_t			mem;				// I/O buffer.
};

struct _dev_data_t
{
	os_pci_t			pci;			// The kernel PCI device descriptor.
	os_data_t			os;				// OS specific data.
	os_spinlock_t		spinlock;		// Control ISR access.
	os_sem_t			sem;			// Control thread access.
	gsc_dev_type_t		board_type;		// Corresponds to basic device type.
	const char*			model;			// Base model number in upper case.
	int					board_index;	// Index of the device being accessed.
	int					users;			// Number of currently active open() requests.
	int					share;			// Were we opened in shared mode?

	gsc_bar_t			bar;			// device register mappings
	gsc_dma_t			dma;			// For DMA based I/O.
	gsc_irq_t			irq;			// For interrut support.
	gsc_wait_node_t*	wait_list;

	struct
	{					// This is for streaming I/O
		dev_io_t		rx;			// Analog Input read
		dev_io_t*		io_streams[DEV_IO_STREAM_QTY];
	} io;

	struct
	{
		VADDR_T			plx_intcsr_32;	// Interrupt Control/Status Register
		VADDR_T			plx_dmaarb_32;	// DMA Arbitration Register
		VADDR_T			plx_dmathr_32;	// DMA Threshold Register

		VADDR_T			gsc_bctlr_32;	// 0x00 Board Control Register
		VADDR_T			gsc_diopr_32;	// 0x04 Digital I/O Port Register
		VADDR_T			gsc_aibr_32;	// 0x18 Analog Input Buffer Register
		VADDR_T			gsc_rgar_32;	// 0x1C Rate Generator A Register
		VADDR_T			gsc_rgbr_32;	// 0x1C Rate Generator B Register
		VADDR_T			gsc_aicr_32;	// 0x24 Analog Input Configuration Register
		VADDR_T			gsc_ibsr_32;	// 0x28 Input Buffer Size Register
		VADDR_T			gsc_ibtr_32;	// 0x2C Input Buffer Threshold Register
		VADDR_T			gsc_icsr_32;	// 0x30 Interrupt Control/Status Register
		VADDR_T			gsc_bcfgr_32;	// 0x34 Board Configuration Register

	} vaddr;

	struct
	{
		s32				ai_chans_max;		// Maximum input channels supported.
		s32				ai_chan_qty;		// The number of input channels on the device.
		s32				ao_chans_max;		// Maximum output channels supported.
		s32				ao_chan_qty;		// The number of output channels on the device.
		s32				auto_cal_ms;		// Maximum ms for auto-cal

		u32				fifo_size_rx;		// Size of Rx FIFO - not the fill level.
		s32				fsamp_max;			// The maximum Fsamp rate per channel.
		s32				fsamp_min;			// The minimum Fsamp rate per channel.

		u32				gsc_bcfgr_32;		// Board Configuration Register

		s32				initialize_ms;		// Maximum ms for initialize

		s32				master_clock;		// Master clock frequency

		s32				rate_gen_fgen_max;	// Rate Generator maximum output rate.
		s32				rate_gen_fgen_min;	// Rate Generator minimum output rate.
		s32				rate_gen_ndiv_mask;	// Mask of valid Ndiv bits.
		s32				rate_gen_ndiv_max;	// Minimum Ndiv value.
		s32				rate_gen_ndiv_min;	// Maximum Ndiv value.
		s32				rate_gen_qty;		// The number of rate generators on device.

	} cache;
};



// prototypes *****************************************************************

void		dev_io_close(dev_data_t* dev);
int			dev_io_create(dev_data_t* dev);
void		dev_io_destroy(dev_data_t* dev);
int			dev_io_open(dev_data_t* dev);
dev_io_t*	dev_io_read_select(dev_data_t* dev, size_t count);
int			dev_irq_create(dev_data_t* dev);
void		dev_irq_destroy(dev_data_t* dev);
int			dev_read_create(dev_data_t* dev, dev_io_t* io);

int			initialize_ioctl(dev_data_t* dev, void* arg);



#endif
