// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/driver/irq.c $
// $Rev: 43127 $
// $Date: 2018-06-29 13:59:49 -0500 (Fri, 29 Jun 2018) $

// 12AISS8AO4: Device Driver: source file

#include "main.h"



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	u32	alt;
	u32	icsr;
	u32	mask;

	icsr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_icsr_32);
	alt		= icsr & (icsr >> 16) & 0x01FF;

	if (alt)
	{
		// Service the active interrupts.
		mask	= alt << 16;
		os_reg_mem_mx_u32(NULL, dev->vaddr.gsc_icsr_32, 0, mask);

		// Resume any threads awiting any of these interrupts.
		gsc_wait_resume_irq_gsc(dev, alt);
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icsr_32, 0);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_icsr_32)
		os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icsr_32, 0);

	gsc_irq_destroy(dev);
}


