// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/api/read.c $
// $Rev: 44603 $
// $Date: 2019-03-13 17:30:49 -0500 (Wed, 13 Mar 2019) $

// 12AISS8AO4: API Library: source file

#include "main.h"



//*****************************************************************************
// Return Values:
//	>=0	= success, the number of bytes transferred
//	<0  = failure, value is -errno or -GetLastError (Windows only)
int aiss8ao4_read(int fd, void* dst, size_t bytes)
{
	int	ret;

	if (bytes > GSC_IO_SIZE_QTY_MASK)
		bytes	= GSC_IO_SIZE_QTY_MASK & ~0x3;

	bytes	|= STREAM_ID_RX;
	ret		= gsc_api_read(fd, dst, bytes);
	return(ret);
}


